/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns;

import com.turo.pushy.apns.ApnsChannelPoolMetricsListener;
import com.turo.pushy.apns.PooledObjectFactory;
import io.netty.channel.Channel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApnsChannelPool {
    private final PooledObjectFactory<Channel> channelFactory;
    private final OrderedEventExecutor executor;
    private final int capacity;
    private final ApnsChannelPoolMetricsListener metricsListener;
    private final ChannelGroup allChannels;
    private final Queue<Channel> idleChannels = new ArrayDeque<Channel>();
    private final Set<Future<Channel>> pendingCreateChannelFutures = new HashSet<Future<Channel>>();
    private final Queue<Promise<Channel>> pendingAcquisitionPromises = new ArrayDeque<Promise<Channel>>();
    private boolean isClosed = false;
    private static final Exception POOL_CLOSED_EXCEPTION = new IllegalStateException("Channel pool has closed and no more channels may be acquired.");
    private static final Logger log = LoggerFactory.getLogger(ApnsChannelPool.class);

    ApnsChannelPool(PooledObjectFactory<Channel> channelFactory, int capacity, OrderedEventExecutor executor, ApnsChannelPoolMetricsListener metricsListener) {
        this.channelFactory = channelFactory;
        this.capacity = capacity;
        this.executor = executor;
        this.metricsListener = metricsListener != null ? metricsListener : new NoopChannelPoolMetricsListener();
        this.allChannels = new DefaultChannelGroup((EventExecutor)this.executor, true);
    }

    Future<Channel> acquire() {
        DefaultPromise acquirePromise = new DefaultPromise((EventExecutor)this.executor);
        if (this.executor.inEventLoop()) {
            this.acquireWithinEventExecutor((Promise<Channel>)acquirePromise);
        } else {
            this.executor.submit(new Runnable((Promise)acquirePromise){
                final /* synthetic */ Promise val$acquirePromise;
                {
                    this.val$acquirePromise = promise;
                }

                @Override
                public void run() {
                    ApnsChannelPool.this.acquireWithinEventExecutor((Promise<Channel>)this.val$acquirePromise);
                }
            }).addListener(new GenericFutureListener((Promise)acquirePromise){
                final /* synthetic */ Promise val$acquirePromise;
                {
                    this.val$acquirePromise = promise;
                }

                public void operationComplete(Future future) throws Exception {
                    if (!future.isSuccess()) {
                        this.val$acquirePromise.tryFailure(future.cause());
                    }
                }
            });
        }
        return acquirePromise;
    }

    private void acquireWithinEventExecutor(final Promise<Channel> acquirePromise) {
        assert (this.executor.inEventLoop());
        if (!this.isClosed) {
            Channel channelFromIdlePool = this.idleChannels.poll();
            if (channelFromIdlePool != null) {
                if (channelFromIdlePool.isActive()) {
                    acquirePromise.trySuccess((Object)channelFromIdlePool);
                } else {
                    this.discardChannel(channelFromIdlePool);
                    this.acquireWithinEventExecutor(acquirePromise);
                }
            } else if (this.allChannels.size() + this.pendingCreateChannelFutures.size() < this.capacity) {
                final Future<Channel> createChannelFuture = this.channelFactory.create((Promise<Channel>)this.executor.newPromise());
                this.pendingCreateChannelFutures.add(createChannelFuture);
                createChannelFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                    public void operationComplete(Future<Channel> future) throws Exception {
                        ApnsChannelPool.this.pendingCreateChannelFutures.remove(createChannelFuture);
                        if (future.isSuccess()) {
                            Channel channel = (Channel)future.getNow();
                            ApnsChannelPool.this.allChannels.add((Object)channel);
                            ApnsChannelPool.this.metricsListener.handleConnectionAdded();
                            acquirePromise.trySuccess((Object)channel);
                        } else {
                            ApnsChannelPool.this.metricsListener.handleConnectionCreationFailed();
                            acquirePromise.tryFailure(future.cause());
                            ApnsChannelPool.this.handleNextAcquisition();
                        }
                    }
                });
            } else {
                this.pendingAcquisitionPromises.add(acquirePromise);
            }
        } else {
            acquirePromise.tryFailure((Throwable)POOL_CLOSED_EXCEPTION);
        }
    }

    void release(final Channel channel) {
        if (this.executor.inEventLoop()) {
            this.releaseWithinEventExecutor(channel);
        } else {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    ApnsChannelPool.this.releaseWithinEventExecutor(channel);
                }
            });
        }
    }

    private void releaseWithinEventExecutor(Channel channel) {
        assert (this.executor.inEventLoop());
        this.idleChannels.add(channel);
        this.handleNextAcquisition();
    }

    private void handleNextAcquisition() {
        assert (this.executor.inEventLoop());
        if (!this.pendingAcquisitionPromises.isEmpty()) {
            this.acquireWithinEventExecutor(this.pendingAcquisitionPromises.poll());
        }
    }

    private void discardChannel(Channel channel) {
        assert (this.executor.inEventLoop());
        this.idleChannels.remove(channel);
        this.allChannels.remove((Object)channel);
        this.metricsListener.handleConnectionRemoved();
        this.channelFactory.destroy(channel, (Promise<Void>)this.executor.newPromise()).addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

            public void operationComplete(Future<Void> destroyFuture) throws Exception {
                if (!destroyFuture.isSuccess()) {
                    log.warn("Failed to destroy channel.", destroyFuture.cause());
                }
            }
        });
    }

    public Future<Void> close() {
        return this.allChannels.close().addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

            public void operationComplete(Future<Void> future) throws Exception {
                ApnsChannelPool.this.isClosed = true;
                if (ApnsChannelPool.this.channelFactory instanceof Closeable) {
                    ((Closeable)((Object)ApnsChannelPool.this.channelFactory)).close();
                }
                for (Promise acquisitionPromise : ApnsChannelPool.this.pendingAcquisitionPromises) {
                    acquisitionPromise.tryFailure((Throwable)POOL_CLOSED_EXCEPTION);
                }
            }
        });
    }

    private static class NoopChannelPoolMetricsListener
    implements ApnsChannelPoolMetricsListener {
        private NoopChannelPoolMetricsListener() {
        }

        @Override
        public void handleConnectionAdded() {
        }

        @Override
        public void handleConnectionRemoved() {
        }

        @Override
        public void handleConnectionCreationFailed() {
        }
    }
}

