/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.server;

import com.turo.pushy.apns.server.ServerSocketChannelClassUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.SucceededFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseHttp2Server {
    private final SslContext sslContext;
    private final AtomicBoolean hasReleasedSslContext = new AtomicBoolean(false);
    private final ServerBootstrap bootstrap;
    private final boolean shouldShutDownEventLoopGroup;
    private ChannelGroup allChannels;
    private static final Logger log = LoggerFactory.getLogger(BaseHttp2Server.class);

    BaseHttp2Server(final SslContext sslContext, EventLoopGroup eventLoopGroup) {
        this.sslContext = sslContext;
        if (this.sslContext instanceof ReferenceCounted) {
            ((ReferenceCounted)this.sslContext).retain();
        }
        this.bootstrap = new ServerBootstrap();
        if (eventLoopGroup != null) {
            this.bootstrap.group(eventLoopGroup);
            this.shouldShutDownEventLoopGroup = false;
        } else {
            this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup(1));
            this.shouldShutDownEventLoopGroup = true;
        }
        this.bootstrap.channel(ServerSocketChannelClassUtil.getServerSocketChannelClass(this.bootstrap.config().group()));
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(final SocketChannel channel) {
                final SslHandler sslHandler = sslContext.newHandler(channel.alloc());
                channel.pipeline().addLast(new ChannelHandler[]{sslHandler});
                channel.pipeline().addLast(new ChannelHandler[]{ConnectionNegotiationErrorHandler.INSTANCE});
                sslHandler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                    public void operationComplete(Future<Channel> handshakeFuture) throws Exception {
                        if (handshakeFuture.isSuccess()) {
                            BaseHttp2Server.this.addHandlersToPipeline(sslHandler.engine().getSession(), channel.pipeline());
                            channel.pipeline().remove((ChannelHandler)ConnectionNegotiationErrorHandler.INSTANCE);
                            BaseHttp2Server.this.allChannels.add((Object)channel);
                        } else {
                            log.debug("TLS handshake failed.", handshakeFuture.cause());
                        }
                    }
                });
            }
        });
    }

    protected abstract void addHandlersToPipeline(SSLSession var1, ChannelPipeline var2) throws Exception;

    public Future<Void> start(int port) {
        ChannelFuture channelFuture = this.bootstrap.bind(port);
        this.allChannels = new DefaultChannelGroup((EventExecutor)channelFuture.channel().eventLoop(), true);
        this.allChannels.add((Object)channelFuture.channel());
        return channelFuture;
    }

    public Future<Void> shutdown() {
        SucceededFuture disconnectFuture;
        SucceededFuture channelCloseFuture;
        Object object = channelCloseFuture = this.allChannels != null ? this.allChannels.close() : new SucceededFuture((EventExecutor)GlobalEventExecutor.INSTANCE, null);
        if (this.shouldShutDownEventLoopGroup) {
            channelCloseFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

                public void operationComplete(Future<Void> future) throws Exception {
                    BaseHttp2Server.this.bootstrap.config().group().shutdownGracefully();
                }
            });
            disconnectFuture = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
            this.bootstrap.config().group().terminationFuture().addListener(new GenericFutureListener((Future)disconnectFuture){
                final /* synthetic */ Future val$disconnectFuture;
                {
                    this.val$disconnectFuture = future;
                }

                public void operationComplete(Future future) throws Exception {
                    ((Promise)this.val$disconnectFuture).trySuccess(null);
                }
            });
        } else {
            disconnectFuture = channelCloseFuture;
        }
        disconnectFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

            public void operationComplete(Future<Void> future) throws Exception {
                if (BaseHttp2Server.this.sslContext instanceof ReferenceCounted && BaseHttp2Server.this.hasReleasedSslContext.compareAndSet(false, true)) {
                    ((ReferenceCounted)BaseHttp2Server.this.sslContext).release();
                }
            }
        });
        return disconnectFuture;
    }

    @ChannelHandler.Sharable
    private static class ConnectionNegotiationErrorHandler
    extends ChannelHandlerAdapter {
        static final ConnectionNegotiationErrorHandler INSTANCE = new ConnectionNegotiationErrorHandler();

        private ConnectionNegotiationErrorHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
            log.debug("Server caught an exception before establishing an HTTP/2 connection.", cause);
        }
    }
}

