/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.auth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.turo.pushy.apns.auth.ApnsSigningKey;
import com.turo.pushy.apns.auth.ApnsVerificationKey;
import com.turo.pushy.apns.util.DateAsTimeSinceEpochTypeAdapter;
import io.netty.util.AsciiString;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;

public class AuthenticationToken {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Date.class, (Object)new DateAsTimeSinceEpochTypeAdapter(TimeUnit.SECONDS)).create();
    private final AuthenticationTokenHeader header;
    private final AuthenticationTokenClaims claims;
    private final byte[] signatureBytes;
    private final transient String base64EncodedToken;
    private final transient AsciiString authorizationHeader;

    public AuthenticationToken(ApnsSigningKey signingKey, Date issuedAt) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        this.header = new AuthenticationTokenHeader(signingKey.getKeyId());
        this.claims = new AuthenticationTokenClaims(signingKey.getTeamId(), issuedAt);
        String headerJson = GSON.toJson((Object)this.header);
        String claimsJson = GSON.toJson((Object)this.claims);
        StringBuilder payloadBuilder = new StringBuilder();
        payloadBuilder.append(Base64.encodeBase64URLSafeString((byte[])headerJson.getBytes(StandardCharsets.US_ASCII)));
        payloadBuilder.append('.');
        payloadBuilder.append(Base64.encodeBase64URLSafeString((byte[])claimsJson.getBytes(StandardCharsets.US_ASCII)));
        Signature signature = Signature.getInstance("SHA256withECDSA");
        signature.initSign(signingKey);
        signature.update(payloadBuilder.toString().getBytes(StandardCharsets.US_ASCII));
        this.signatureBytes = signature.sign();
        payloadBuilder.append('.');
        payloadBuilder.append(Base64.encodeBase64URLSafeString((byte[])this.signatureBytes));
        this.base64EncodedToken = payloadBuilder.toString();
        this.authorizationHeader = new AsciiString((CharSequence)("bearer " + payloadBuilder.toString()));
    }

    public AuthenticationToken(String base64EncodedToken) {
        Objects.requireNonNull(base64EncodedToken, "Encoded token must not be null.");
        this.base64EncodedToken = base64EncodedToken;
        this.authorizationHeader = new AsciiString((CharSequence)("bearer " + base64EncodedToken));
        String[] jwtSegments = base64EncodedToken.split("\\.");
        if (jwtSegments.length != 3) {
            throw new IllegalArgumentException();
        }
        this.header = (AuthenticationTokenHeader)GSON.fromJson(new String(Base64.decodeBase64((String)jwtSegments[0]), StandardCharsets.US_ASCII), AuthenticationTokenHeader.class);
        this.claims = (AuthenticationTokenClaims)GSON.fromJson(new String(Base64.decodeBase64((String)jwtSegments[1]), StandardCharsets.US_ASCII), AuthenticationTokenClaims.class);
        this.signatureBytes = Base64.decodeBase64((String)jwtSegments[2]);
    }

    public Date getIssuedAt() {
        return this.claims.getIssuedAt();
    }

    public String getKeyId() {
        return this.header.getKeyId();
    }

    public String getTeamId() {
        return this.claims.getIssuer();
    }

    public boolean verifySignature(ApnsVerificationKey verificationKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.header.getKeyId().equals(verificationKey.getKeyId())) {
            return false;
        }
        if (!this.claims.getIssuer().equals(verificationKey.getTeamId())) {
            return false;
        }
        String headerJson = GSON.toJson((Object)this.header);
        String claimsJson = GSON.toJson((Object)this.claims);
        StringBuilder headerAndClaimsBuilder = new StringBuilder();
        headerAndClaimsBuilder.append(Base64.encodeBase64URLSafeString((byte[])headerJson.getBytes(StandardCharsets.US_ASCII)));
        headerAndClaimsBuilder.append('.');
        headerAndClaimsBuilder.append(Base64.encodeBase64URLSafeString((byte[])claimsJson.getBytes(StandardCharsets.US_ASCII)));
        byte[] headerAndClaimsBytes = headerAndClaimsBuilder.toString().getBytes(StandardCharsets.US_ASCII);
        Signature signature = Signature.getInstance("SHA256withECDSA");
        signature.initVerify(verificationKey);
        signature.update(headerAndClaimsBytes);
        return signature.verify(this.signatureBytes);
    }

    public AsciiString getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    public String toString() {
        return this.base64EncodedToken;
    }

    public int hashCode() {
        return this.base64EncodedToken.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationToken)) {
            return false;
        }
        AuthenticationToken other = (AuthenticationToken)obj;
        return !(this.base64EncodedToken == null ? other.base64EncodedToken != null : !this.base64EncodedToken.equals(other.base64EncodedToken));
    }

    private static class AuthenticationTokenClaims {
        @SerializedName(value="iss")
        private final String issuer;
        @SerializedName(value="iat")
        private final Date issuedAt;

        AuthenticationTokenClaims(String teamId, Date issuedAt) {
            this.issuer = teamId;
            this.issuedAt = issuedAt;
        }

        String getIssuer() {
            return this.issuer;
        }

        Date getIssuedAt() {
            return this.issuedAt;
        }
    }

    private static class AuthenticationTokenHeader {
        @SerializedName(value="alg")
        private final String algorithm = "ES256";
        @SerializedName(value="typ")
        private final String tokenType = "JWT";
        @SerializedName(value="kid")
        private final String keyId;

        AuthenticationTokenHeader(String keyId) {
            this.keyId = keyId;
        }

        String getKeyId() {
            return this.keyId;
        }
    }
}

