/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.CharArrayWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApnsPayloadBuilder {
    private String alertBody = null;
    private String localizedAlertKey = null;
    private String[] localizedAlertArguments = null;
    private String alertTitle = null;
    private String localizedAlertTitleKey = null;
    private String[] localizedAlertTitleArguments = null;
    private String alertSubtitle = null;
    private String localizedAlertSubtitleKey = null;
    private String[] localizedAlertSubtitleArguments = null;
    private String launchImageFileName = null;
    private boolean showActionButton = true;
    private String actionButtonLabel = null;
    private String localizedActionButtonKey = null;
    private Integer badgeNumber = null;
    private String soundFileName = null;
    private String categoryName = null;
    private boolean contentAvailable = false;
    private boolean mutableContent = false;
    private String threadId = null;
    private String[] urlArguments = null;
    private boolean preferStringRepresentationForAlerts = false;
    private final CharArrayWriter buffer = new CharArrayWriter(1024);
    private static final String APS_KEY = "aps";
    private static final String ALERT_KEY = "alert";
    private static final String BADGE_KEY = "badge";
    private static final String SOUND_KEY = "sound";
    private static final String CATEGORY_KEY = "category";
    private static final String CONTENT_AVAILABLE_KEY = "content-available";
    private static final String MUTABLE_CONTENT_KEY = "mutable-content";
    private static final String THREAD_ID_KEY = "thread-id";
    private static final String URL_ARGS_KEY = "url-args";
    private static final String ALERT_TITLE_KEY = "title";
    private static final String ALERT_TITLE_LOC_KEY = "title-loc-key";
    private static final String ALERT_TITLE_ARGS_KEY = "title-loc-args";
    private static final String ALERT_SUBTITLE_KEY = "subtitle";
    private static final String ALERT_SUBTITLE_LOC_KEY = "subtitle-loc-key";
    private static final String ALERT_SUBTITLE_ARGS_KEY = "subtitle-loc-args";
    private static final String ALERT_BODY_KEY = "body";
    private static final String ALERT_LOC_KEY = "loc-key";
    private static final String ALERT_ARGS_KEY = "loc-args";
    private static final String ACTION_KEY = "action";
    private static final String ACTION_LOC_KEY = "action-loc-key";
    private static final String LAUNCH_IMAGE_KEY = "launch-image";
    private final HashMap<String, Object> customProperties = new HashMap();
    private static final String ABBREVIATION_SUBSTRING = "\u2026";
    private static final Gson gson = new GsonBuilder().serializeNulls().disableHtmlEscaping().create();
    public static final String DEFAULT_SOUND_FILENAME = "default";
    public static final int DEFAULT_MAXIMUM_PAYLOAD_SIZE = 4096;

    public ApnsPayloadBuilder setPreferStringRepresentationForAlerts(boolean preferStringRepresentationForAlerts) {
        this.preferStringRepresentationForAlerts = preferStringRepresentationForAlerts;
        return this;
    }

    public ApnsPayloadBuilder setAlertBody(String alertBody) {
        this.alertBody = alertBody;
        this.localizedAlertKey = null;
        this.localizedAlertArguments = null;
        return this;
    }

    public ApnsPayloadBuilder setLocalizedAlertMessage(String localizedAlertKey, String ... alertArguments) {
        this.localizedAlertKey = localizedAlertKey;
        this.localizedAlertArguments = alertArguments != null && alertArguments.length > 0 ? alertArguments : null;
        this.alertBody = null;
        return this;
    }

    public ApnsPayloadBuilder setAlertTitle(String alertTitle) {
        this.alertTitle = alertTitle;
        this.localizedAlertTitleKey = null;
        this.localizedAlertTitleArguments = null;
        return this;
    }

    public ApnsPayloadBuilder setLocalizedAlertTitle(String localizedAlertTitleKey, String ... alertTitleArguments) {
        this.localizedAlertTitleKey = localizedAlertTitleKey;
        this.localizedAlertTitleArguments = alertTitleArguments != null && alertTitleArguments.length > 0 ? alertTitleArguments : null;
        this.alertTitle = null;
        return this;
    }

    public ApnsPayloadBuilder setAlertSubtitle(String alertSubtitle) {
        this.alertSubtitle = alertSubtitle;
        this.localizedAlertSubtitleKey = null;
        this.localizedAlertSubtitleArguments = null;
        return this;
    }

    public ApnsPayloadBuilder setLocalizedAlertSubtitle(String localizedAlertSubtitleKey, String ... alertSubtitleArguments) {
        this.localizedAlertSubtitleKey = localizedAlertSubtitleKey;
        this.localizedAlertSubtitleArguments = alertSubtitleArguments != null && alertSubtitleArguments.length > 0 ? alertSubtitleArguments : null;
        this.alertSubtitle = null;
        return this;
    }

    public ApnsPayloadBuilder setLaunchImageFileName(String launchImageFilename) {
        this.launchImageFileName = launchImageFilename;
        return this;
    }

    public ApnsPayloadBuilder setShowActionButton(boolean showActionButton) {
        this.showActionButton = showActionButton;
        return this;
    }

    public ApnsPayloadBuilder setActionButtonLabel(String action) {
        this.actionButtonLabel = action;
        this.localizedActionButtonKey = null;
        return this;
    }

    public ApnsPayloadBuilder setLocalizedActionButtonKey(String localizedActionButtonKey) {
        this.localizedActionButtonKey = localizedActionButtonKey;
        this.actionButtonLabel = null;
        return this;
    }

    public ApnsPayloadBuilder setBadgeNumber(Integer badgeNumber) {
        this.badgeNumber = badgeNumber;
        return this;
    }

    public ApnsPayloadBuilder setCategoryName(String categoryName) {
        this.categoryName = categoryName;
        return this;
    }

    public ApnsPayloadBuilder setSoundFileName(String soundFileName) {
        this.soundFileName = soundFileName;
        return this;
    }

    public ApnsPayloadBuilder setContentAvailable(boolean contentAvailable) {
        this.contentAvailable = contentAvailable;
        return this;
    }

    public ApnsPayloadBuilder setMutableContent(boolean mutableContent) {
        this.mutableContent = mutableContent;
        return this;
    }

    public ApnsPayloadBuilder setThreadId(String threadId) {
        this.threadId = threadId;
        return this;
    }

    public ApnsPayloadBuilder setUrlArguments(List<String> arguments) {
        return this.setUrlArguments(arguments != null ? arguments.toArray(new String[0]) : null);
    }

    public ApnsPayloadBuilder setUrlArguments(String ... arguments) {
        this.urlArguments = arguments;
        return this;
    }

    public ApnsPayloadBuilder addCustomProperty(String key, Object value) {
        this.customProperties.put(key, value);
        return this;
    }

    public String buildWithDefaultMaximumLength() {
        return this.buildWithMaximumLength(4096);
    }

    public String buildWithMaximumLength(int maximumPayloadSize) {
        String fittedPayloadString;
        HashMap<String, Object> payload = new HashMap<String, Object>();
        HashMap<String, Object> aps = new HashMap<String, Object>();
        if (this.badgeNumber != null) {
            aps.put(BADGE_KEY, this.badgeNumber);
        }
        if (this.soundFileName != null) {
            aps.put(SOUND_KEY, this.soundFileName);
        }
        if (this.categoryName != null) {
            aps.put(CATEGORY_KEY, this.categoryName);
        }
        if (this.contentAvailable) {
            aps.put(CONTENT_AVAILABLE_KEY, 1);
        }
        if (this.mutableContent) {
            aps.put(MUTABLE_CONTENT_KEY, 1);
        }
        if (this.threadId != null) {
            aps.put(THREAD_ID_KEY, this.threadId);
        }
        if (this.urlArguments != null) {
            aps.put(URL_ARGS_KEY, this.urlArguments);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.alertBody != null) {
            hashMap.put(ALERT_BODY_KEY, this.alertBody);
        }
        if (this.alertTitle != null) {
            hashMap.put(ALERT_TITLE_KEY, this.alertTitle);
        }
        if (this.alertSubtitle != null) {
            hashMap.put(ALERT_SUBTITLE_KEY, this.alertSubtitle);
        }
        if (this.showActionButton) {
            if (this.localizedActionButtonKey != null) {
                hashMap.put(ACTION_LOC_KEY, this.localizedActionButtonKey);
            }
            if (this.actionButtonLabel != null) {
                hashMap.put(ACTION_KEY, this.actionButtonLabel);
            }
        } else {
            hashMap.put(ACTION_LOC_KEY, null);
        }
        if (this.localizedAlertKey != null) {
            hashMap.put(ALERT_LOC_KEY, this.localizedAlertKey);
            if (this.localizedAlertArguments != null) {
                hashMap.put(ALERT_ARGS_KEY, Arrays.asList(this.localizedAlertArguments));
            }
        }
        if (this.localizedAlertTitleKey != null) {
            hashMap.put(ALERT_TITLE_LOC_KEY, this.localizedAlertTitleKey);
            if (this.localizedAlertTitleArguments != null) {
                hashMap.put(ALERT_TITLE_ARGS_KEY, Arrays.asList(this.localizedAlertTitleArguments));
            }
        }
        if (this.localizedAlertSubtitleKey != null) {
            hashMap.put(ALERT_SUBTITLE_LOC_KEY, this.localizedAlertSubtitleKey);
            if (this.localizedAlertSubtitleArguments != null) {
                hashMap.put(ALERT_SUBTITLE_ARGS_KEY, Arrays.asList(this.localizedAlertSubtitleArguments));
            }
        }
        if (this.launchImageFileName != null) {
            hashMap.put(LAUNCH_IMAGE_KEY, this.launchImageFileName);
        }
        if (hashMap.size() == 1 && hashMap.containsKey(ALERT_BODY_KEY) && this.preferStringRepresentationForAlerts) {
            aps.put(ALERT_KEY, hashMap.get(ALERT_BODY_KEY));
        } else if (!hashMap.isEmpty()) {
            aps.put(ALERT_KEY, hashMap);
        }
        payload.put(APS_KEY, aps);
        for (Map.Entry entry : this.customProperties.entrySet()) {
            payload.put((String)entry.getKey(), entry.getValue());
        }
        this.buffer.reset();
        gson.toJson(payload, (Appendable)this.buffer);
        String payloadString = this.buffer.toString();
        int n = payloadString.getBytes(StandardCharsets.UTF_8).length;
        if (n <= maximumPayloadSize) {
            fittedPayloadString = payloadString;
        } else if (this.alertBody != null) {
            this.replaceMessageBody(payload, "");
            this.buffer.reset();
            gson.toJson(payload, (Appendable)this.buffer);
            int payloadSizeWithEmptyMessage = this.buffer.toString().getBytes(StandardCharsets.UTF_8).length;
            if (payloadSizeWithEmptyMessage >= maximumPayloadSize) {
                throw new IllegalArgumentException("Payload exceeds maximum size even with an empty message body.");
            }
            int maximumEscapedMessageBodySize = maximumPayloadSize - payloadSizeWithEmptyMessage - ABBREVIATION_SUBSTRING.getBytes(StandardCharsets.UTF_8).length;
            String fittedMessageBody = this.alertBody.substring(0, ApnsPayloadBuilder.getLengthOfJsonEscapedUtf8StringFittingSize(this.alertBody, maximumEscapedMessageBodySize));
            this.replaceMessageBody(payload, fittedMessageBody + ABBREVIATION_SUBSTRING);
            this.buffer.reset();
            gson.toJson(payload, (Appendable)this.buffer);
            fittedPayloadString = this.buffer.toString();
        } else {
            throw new IllegalArgumentException(String.format("Payload size is %d bytes (with a maximum of %d bytes) and cannot be shortened.", n, maximumPayloadSize));
        }
        return fittedPayloadString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void replaceMessageBody(Map<String, Object> payload, String messageBody) {
        Map aps = (Map)payload.get(APS_KEY);
        Object alert = aps.get(ALERT_KEY);
        if (alert == null) throw new IllegalArgumentException("Payload has no message body.");
        if (alert instanceof String) {
            aps.put(ALERT_KEY, messageBody);
            return;
        } else {
            Map alertObject = (Map)alert;
            if (alertObject.get(ALERT_BODY_KEY) == null) throw new IllegalArgumentException("Payload has no message body.");
            alertObject.put(ALERT_BODY_KEY, messageBody);
        }
    }

    static int getLengthOfJsonEscapedUtf8StringFittingSize(String string, int maximumSize) {
        char c;
        int charSize;
        int i = 0;
        int cumulativeSize = 0;
        for (i = 0; i < string.length() && cumulativeSize + (charSize = ApnsPayloadBuilder.getSizeOfJsonEscapedUtf8Character(c = string.charAt(i))) <= maximumSize; ++i) {
            cumulativeSize += charSize;
            if (!Character.isHighSurrogate(c)) continue;
            ++i;
        }
        return i;
    }

    static int getSizeOfJsonEscapedUtf8Character(char c) {
        int charSize = c == '\"' || c == '\\' || c == '\b' || c == '\f' || c == '\n' || c == '\r' || c == '\t' ? 2 : (c <= '\u001f' || c == '\u2028' || c == '\u2029' ? 6 : (c <= '\u007f' ? 1 : (c <= '\u07ff' ? 2 : (Character.isHighSurrogate(c) ? 4 : 3))));
        return charSize;
    }
}

