/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.dfa;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.antlr.v4.runtime.dfa.AbstractEdgeMap;
import org.antlr.v4.runtime.dfa.EdgeMap;
import org.antlr.v4.runtime.dfa.SingletonEdgeMap;
import org.antlr.v4.runtime.dfa.SparseEdgeMap;

public class ArrayEdgeMap<T>
extends AbstractEdgeMap<T> {
    private final T[] arrayData;
    private int size;

    public ArrayEdgeMap(int minIndex, int maxIndex) {
        super(minIndex, maxIndex);
        this.arrayData = new Object[maxIndex - minIndex + 1];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    @Override
    public T get(int key) {
        if (key < this.minIndex || key > this.maxIndex) {
            return null;
        }
        return this.arrayData[key - this.minIndex];
    }

    @Override
    public ArrayEdgeMap<T> put(int key, T value) {
        if (key >= this.minIndex && key <= this.maxIndex) {
            T existing = this.arrayData[key - this.minIndex];
            this.arrayData[key - this.minIndex] = value;
            if (existing == null && value != null) {
                ++this.size;
            } else if (existing != null && value == null) {
                --this.size;
            }
        }
        return this;
    }

    @Override
    public ArrayEdgeMap<T> remove(int key) {
        return this.put(key, (Object)null);
    }

    @Override
    public ArrayEdgeMap<T> putAll(EdgeMap<? extends T> m) {
        if (m.isEmpty()) {
            return this;
        }
        if (m instanceof ArrayEdgeMap) {
            ArrayEdgeMap other = (ArrayEdgeMap)m;
            int minOverlap = Math.max(this.minIndex, other.minIndex);
            int maxOverlap = Math.min(this.maxIndex, other.maxIndex);
            for (int i = minOverlap; i <= maxOverlap; ++i) {
                T target = other.arrayData[i - other.minIndex];
                if (target == null) continue;
                T current = this.arrayData[i - this.minIndex];
                this.arrayData[i - this.minIndex] = target;
                this.size += current != null ? 0 : 1;
            }
            return this;
        }
        if (m instanceof SingletonEdgeMap) {
            SingletonEdgeMap other = (SingletonEdgeMap)m;
            assert (!other.isEmpty());
            return this.put(other.getKey(), other.getValue());
        }
        if (m instanceof SparseEdgeMap) {
            SparseEdgeMap other = (SparseEdgeMap)m;
            int[] keys = other.getKeys();
            List values = other.getValues();
            AbstractEdgeMap result = this;
            for (int i = 0; i < values.size(); ++i) {
                result = result.put(keys[i], values.get(i));
            }
            return result;
        }
        throw new UnsupportedOperationException(String.format("EdgeMap of type %s is supported yet.", m.getClass().getName()));
    }

    @Override
    public ArrayEdgeMap<T> clear() {
        Arrays.fill(this.arrayData, null);
        return this;
    }

    @Override
    public Map<Integer, T> toMap() {
        if (this.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Integer, T> result = new LinkedHashMap<Integer, T>();
        for (int i = 0; i < this.arrayData.length; ++i) {
            if (this.arrayData[i] == null) continue;
            result.put(i + this.minIndex, this.arrayData[i]);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<Integer, T>> entrySet() {
        return new EntrySet();
    }

    private class EntryIterator
    implements Iterator<Map.Entry<Integer, T>> {
        private int current;
        private int currentIndex;

        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < ArrayEdgeMap.this.size();
        }

        @Override
        public Map.Entry<Integer, T> next() {
            if (this.current >= ArrayEdgeMap.this.size()) {
                throw new NoSuchElementException();
            }
            while (ArrayEdgeMap.this.arrayData[this.currentIndex] == null) {
                ++this.currentIndex;
            }
            ++this.current;
            ++this.currentIndex;
            return new Map.Entry<Integer, T>(){
                private final int key;
                private final T value;
                {
                    this.key = ArrayEdgeMap.this.minIndex + EntryIterator.this.currentIndex - 1;
                    this.value = ArrayEdgeMap.this.arrayData[EntryIterator.this.currentIndex - 1];
                }

                @Override
                public Integer getKey() {
                    return this.key;
                }

                @Override
                public T getValue() {
                    return this.value;
                }

                @Override
                public T setValue(T value) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class EntrySet
    extends AbstractEdgeMap.AbstractEntrySet {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, T>> iterator() {
            return new EntryIterator();
        }
    }
}

