/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.misc.IntegerList;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Predicate;

public class Utils {
    public static String join(Iterable<?> iter, String separator) {
        return Utils.join(iter.iterator(), separator);
    }

    public static <T> String join(T[] array, String separator) {
        return Utils.join(Arrays.asList(array), separator);
    }

    public static <T> String join(Iterator<T> iter, String separator) {
        StringBuilder buf = new StringBuilder();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public static int numNonnull(Object[] data) {
        int n = 0;
        if (data == null) {
            return n;
        }
        for (Object o : data) {
            if (o == null) continue;
            ++n;
        }
        return n;
    }

    public static <T> void removeAllElements(Collection<T> data, T value) {
        if (data == null) {
            return;
        }
        while (data.contains(value)) {
            data.remove(value);
        }
    }

    public static String escapeWhitespace(String s, boolean escapeSpaces) {
        StringBuilder buf = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c == ' ' && escapeSpaces) {
                buf.append('\u00b7');
                continue;
            }
            if (c == '\t') {
                buf.append("\\t");
                continue;
            }
            if (c == '\n') {
                buf.append("\\n");
                continue;
            }
            if (c == '\r') {
                buf.append("\\r");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fileName, String content) throws IOException {
        FileWriter fw = new FileWriter(fileName);
        BufferedWriter w = new BufferedWriter(fw);
        try {
            w.write(content);
        }
        finally {
            ((Writer)w).close();
        }
    }

    public static <T> void removeAll(@NotNull List<T> list, @NotNull Predicate<? super T> predicate) {
        int j = 0;
        for (int i = 0; i < list.size(); ++i) {
            T item = list.get(i);
            if (predicate.eval(item)) continue;
            if (j != i) {
                list.set(j, item);
            }
            ++j;
        }
        if (j < list.size()) {
            list.subList(j, list.size()).clear();
        }
    }

    public static <T> void removeAll(@NotNull Iterable<T> iterable, @NotNull Predicate<? super T> predicate) {
        if (iterable instanceof List) {
            Utils.removeAll((List)iterable, predicate);
            return;
        }
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (!predicate.eval(item)) continue;
            iterator.remove();
        }
    }

    public static void waitForClose(final Window window) throws InterruptedException {
        final Object lock = new Object();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    while (window.isVisible()) {
                        try {
                            lock.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        };
        t.start();
        window.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent arg0) {
                Object object = lock;
                synchronized (object) {
                    window.setVisible(false);
                    lock.notify();
                }
            }
        });
        t.join();
    }

    public static Map<String, Integer> toMap(String[] keys) {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        for (int i = 0; i < keys.length; ++i) {
            m.put(keys[i], i);
        }
        return m;
    }

    public static char[] toCharArray(IntegerList data) {
        if (data == null) {
            return null;
        }
        char[] cdata = new char[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            cdata[i] = (char)data.get(i);
        }
        return cdata;
    }
}

