/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor.tools.Logger;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.tts.android.aopmonitor.tools.Logger.LogStrategy;
import com.tts.android.aopmonitor.tools.Logger.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class DiskLogStrategy
implements LogStrategy {
    @NonNull
    private final Handler handler;

    public DiskLogStrategy(@NonNull Handler handler) {
        this.handler = Utils.checkNotNull(handler);
    }

    @Override
    public void log(int level, @Nullable String tag, @NonNull String message) {
        Utils.checkNotNull(message);
        this.handler.sendMessage(this.handler.obtainMessage(level, (Object)message));
    }

    static class WriteHandler
    extends Handler {
        @NonNull
        private final String folder;
        private final int maxFileSize;

        WriteHandler(@NonNull Looper looper, @NonNull String folder, int maxFileSize) {
            super(Utils.checkNotNull(looper));
            this.folder = Utils.checkNotNull(folder);
            this.maxFileSize = maxFileSize;
        }

        public void handleMessage(@NonNull Message msg) {
            block4: {
                String content = (String)msg.obj;
                FileWriter fileWriter = null;
                File logFile = this.getLogFile(this.folder, "logs");
                try {
                    fileWriter = new FileWriter(logFile, true);
                    this.writeLog(fileWriter, content);
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (IOException e) {
                    if (fileWriter == null) break block4;
                    try {
                        fileWriter.flush();
                        fileWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        private void writeLog(@NonNull FileWriter fileWriter, @NonNull String content) throws IOException {
            Utils.checkNotNull(fileWriter);
            Utils.checkNotNull(content);
            fileWriter.append(content);
        }

        private File getLogFile(@NonNull String folderName, @NonNull String fileName) {
            Utils.checkNotNull(folderName);
            Utils.checkNotNull(fileName);
            File folder = new File(folderName);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            int newFileCount = 0;
            File existingFile = null;
            File newFile = new File(folder, String.format("%s_%s.csv", fileName, newFileCount));
            while (newFile.exists()) {
                existingFile = newFile;
                newFile = new File(folder, String.format("%s_%s.csv", fileName, ++newFileCount));
            }
            if (existingFile != null) {
                if (existingFile.length() >= (long)this.maxFileSize) {
                    return newFile;
                }
                return existingFile;
            }
            return newFile;
        }
    }
}

