/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor.aspect;

import com.google.gson.Gson;
import com.tts.android.aopmonitor.bean.CrashRecordBean;
import com.tts.android.aopmonitor.common.CommonInit;
import com.tts.android.aopmonitor.tools.LogUtils;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class UnCatchExAspect {
    @Pointcut(value="execution(@com.tts.android.aopmonitor.annotation.BindUnCatchEx * *(..))")
    public void unCatchExMethod() {
    }

    @After(value="unCatchExMethod()")
    public void crashCollect(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        Thread thread = null;
        Throwable throwable = null;
        Object[] args = point.getArgs();
        if (args.length == 2 && args[0] instanceof Thread && args[1] instanceof Throwable) {
            thread = (Thread)args[0];
            throwable = (Throwable)args[1];
        }
        if (null != thread && null != throwable) {
            CrashRecordBean crashRecordBean = new CrashRecordBean();
            CommonInit.initBaseRecordBean(crashRecordBean);
            crashRecordBean.setCrashMsg(throwable.getMessage());
            StringBuilder exResult = new StringBuilder();
            for (StackTraceElement element : throwable.getStackTrace()) {
                exResult.append(element.toString());
                exResult.append("\n");
            }
            crashRecordBean.setCrashStackTrace(exResult.toString());
            LogUtils.logjson(new Gson().toJson((Object)crashRecordBean));
        } else {
            LogUtils.logd("method param type is wrong");
        }
    }
}

