/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor.aspect;

import android.app.Fragment;
import android.content.Context;
import com.blankj.utilcode.util.DeviceUtils;
import com.tts.android.aopmonitor.annotation.NeedPermission;
import com.tts.android.aopmonitor.annotation.PermissionDenied;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.AndPermission;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class NeedPermissionAspect {
    private static final int ANDROID_M = 23;

    @Pointcut(value="execution(@com.tts.android.aopmonitor.annotation.NeedPermission * *(..)) && @annotation(needPermission)")
    public void needPermission(NeedPermission needPermission) {
    }

    @Around(value="needPermission(needPermission)")
    public void checkPermission(final ProceedingJoinPoint point, NeedPermission needPermission) {
        Context context = null;
        final Object object = point.getThis();
        if (object instanceof Context) {
            context = (Context)object;
        } else if (object instanceof Fragment) {
            context = ((Fragment)object).getActivity();
        } else if (object instanceof android.support.v4.app.Fragment) {
            context = ((android.support.v4.app.Fragment)object).getActivity();
        }
        if (context == null || needPermission == null) {
            LogUtils.loge("the method is not belong to a activity or fragment, or NeedPermission annotation not found");
            try {
                point.proceed();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return;
        }
        if (DeviceUtils.getSDKVersionCode() < 23) {
            try {
                point.proceed();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return;
        }
        AndPermission.with((Context)context).runtime().permission(needPermission.value()).onGranted((Action)new Action<List<String>>(){

            public void onAction(List<String> data) {
                try {
                    point.proceed();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }).onDenied((Action)new Action<List<String>>(){

            public void onAction(List<String> data) {
                Class<?> cls = object.getClass();
                Method[] methods = cls.getDeclaredMethods();
                if (methods == null || methods.length == 0) {
                    return;
                }
                for (Method method : methods) {
                    boolean isHasAnnotation = method.isAnnotationPresent(PermissionDenied.class);
                    if (!isHasAnnotation) continue;
                    method.setAccessible(true);
                    Class<?>[] types = method.getParameterTypes();
                    PermissionDenied aInfo = method.getAnnotation(PermissionDenied.class);
                    if (aInfo == null) {
                        return;
                    }
                    try {
                        if (null != types && types.length == 1) {
                            method.invoke(object, data);
                            continue;
                        }
                        method.invoke(object, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }
}

