/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor.actmanager;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.push.PageCenter;
import com.tts.push.bean.OnePageBean;

public class Navigation {
    public Context context;
    public String url;
    public Bundle data;

    public Navigation(Context context) {
        this.context = context;
    }

    public void jump() {
        Class targetPage = null;
        if (!TextUtils.isEmpty((CharSequence)this.url) && PageCenter.mPages.containsKey(this.url)) {
            targetPage = ((OnePageBean)PageCenter.mPages.get(this.url)).getAct();
        }
        if (null == targetPage) {
            LogUtils.loge("activity target is null");
            return;
        }
        Intent intent = new Intent(this.context, targetPage);
        if (null != this.data) {
            intent.putExtra("data", this.data);
        }
        this.context.startActivity(intent);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Bundle getData() {
        return this.data;
    }

    public void setData(Bundle data) {
        this.data = data;
    }

    public static class Builder {
        public Navigation target;

        public Builder(Context context) {
            this.target = new Navigation(context);
        }

        public Builder url(String url) {
            this.target.setUrl(url);
            return this;
        }

        public Builder data(Bundle bundle) {
            this.target.setData(bundle);
            return this;
        }

        public Navigation build() {
            return this.target;
        }
    }
}

