/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor.actmanager;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.tts.android.aopmonitor.actmanager.ActivityResultCallBack;
import com.tts.android.aopmonitor.actmanager.StartCallbackFragment;

public class ActivityStartResultManager {
    private static final String TAG = ActivityStartResultManager.class.getSimpleName();
    private StartCallbackFragment mStartCallbackFragment;
    private Class<?> mTargetClass;
    private Bundle mDataBundle;
    private String mAction;
    private Uri mUri;

    public static ActivityStartResultManager get() {
        return new ActivityStartResultManager();
    }

    private ActivityStartResultManager() {
    }

    public ActivityStartResultManager from(Activity activity) {
        this.mStartCallbackFragment = this.createStartCallbackFragment(activity);
        return this;
    }

    public ActivityStartResultManager from(Fragment fragment) {
        this.from(fragment.getActivity());
        return this;
    }

    public ActivityStartResultManager to(Class<?> clazz) {
        this.mTargetClass = clazz;
        return this;
    }

    public ActivityStartResultManager bundle(Bundle bundle) {
        this.mDataBundle = new Bundle(bundle);
        return this;
    }

    public ActivityStartResultManager action(String action) {
        this.mAction = action;
        return this;
    }

    public ActivityStartResultManager uri(Uri uri) {
        this.mUri = uri;
        return this;
    }

    public void startForResult(@NonNull ActivityResultCallBack callback) {
        if (this.mStartCallbackFragment == null) {
            throw new NullPointerException("From activity is null , forget from() ?");
        }
        Activity activity = this.mStartCallbackFragment.getActivity();
        if (activity == null) {
            throw new NullPointerException("Surprise , something is error , perhaps this is love");
        }
        Intent intent = null;
        if (null != this.mTargetClass) {
            intent = new Intent((Context)activity, this.mTargetClass);
            if (this.mDataBundle != null) {
                intent.putExtras(this.mDataBundle);
            }
        } else if (this.mAction != null && this.mUri != null) {
            intent = new Intent(this.mAction, this.mUri);
            if (this.mDataBundle != null) {
                intent.putExtras(this.mDataBundle);
            }
        } else {
            throw new NullPointerException("target is null , forget to() or action()&uri() ?");
        }
        this.fragmentStartForResult(intent, callback.hashCode(), callback);
    }

    private StartCallbackFragment createStartCallbackFragment(Activity activity) {
        StartCallbackFragment resultFragment = this.findStartCallbackFragment(activity);
        if (resultFragment == null) {
            resultFragment = new StartCallbackFragment();
            FragmentManager fragmentManager = activity.getFragmentManager();
            fragmentManager.beginTransaction().add((Fragment)resultFragment, TAG).commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return resultFragment;
    }

    private StartCallbackFragment findStartCallbackFragment(Activity activity) {
        return (StartCallbackFragment)activity.getFragmentManager().findFragmentByTag(TAG);
    }

    private void fragmentStartForResult(Intent intent, int requestCode, ActivityResultCallBack callback) {
        this.mStartCallbackFragment.startForResult(intent, requestCode, callback);
    }
}

