package com.tts.android.aopmonitor.tools;

import android.util.Log;

import com.tts.android.aopmonitor.tools.Logger.AndroidLogAdapter;
import com.tts.android.aopmonitor.tools.Logger.FormatStrategy;
import com.tts.android.aopmonitor.tools.Logger.Logger;
import com.tts.android.aopmonitor.tools.Logger.PrettyFormatStrategy;

/**
 * 打印Log管理
 * @author shijianting
 * 2018/11/27 9:03 AM
 */
public class LogUtils {

    public static void logd (String content) {
        if (!Constants.options.isDebug()) {
            return;
        }
        Logger.d(content);
    }

    public static void loge (String content) {
        if (!Constants.options.isDebug()) {
            return;
        }
        Logger.e(content);
    }

    public static void logjson(String jsonContent) {
        if (!Constants.options.isDebug()) {
            return;
        }
        Logger.json(jsonContent);
    }

    /**
     * check logger status and fix
     */
    private static void checkAndFixLogger() {
        if (null == Logger.getLogList() || Logger.getLogList().size() != 1) {
            initLogger();
        }
    }

    /**
     * init logger
     */
    public static void initLogger() {
        Logger.clearLogAdapters();
        FormatStrategy formatStrategy = PrettyFormatStrategy.newBuilder()
                //是否显示所在进程
                .showThreadInfo(false)
                //显示方法行数
                .methodCount(0)
                //日志标签
                .tag("AOPMonitor")
                .build();
        //初始化日志系统
        Logger.addLogAdapter(new AndroidLogAdapter(formatStrategy));
    }
}
