package com.tts.android.aopmonitor.tools;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.text.TextUtils;

import com.tts.android.aopmonitor.actmanager.ActivityResultCallBack;
import com.tts.android.aopmonitor.actmanager.ActivityStartResultManager;

/**
 * 联系人相关功能
 * @author shijianting
 * 2018/11/14 10:47 AM
 */
public class ContactUtils {

    /**
     * 调起通讯录,并返回选中联系人
     * 有系统限制
     * @param context
     * @param listener
     */
    public static void executeGetContact(final Context context, final ContactListener listener) throws Exception{
        if (null == context || !(context instanceof Activity)) {
            LogUtils.loge("param is null, or context is not a activity");
            return;
        }
        ActivityStartResultManager.get()
                .from((Activity)context)
                .action(Intent.ACTION_PICK)
                .uri(ContactsContract.Contacts.CONTENT_URI)
                .startForResult(new ActivityResultCallBack() {
                    @Override
                    public void onResultError() {
                        listener.fail("can not open the system contact");
                    }

                    @Override
                    public void onActivityResult(int resultCode, Intent data) {
                        if (Activity.RESULT_OK == resultCode) {
                            ContentResolver contentResolver = context.getApplicationContext().getContentResolver();
                            Uri contactData = data.getData();

                            // 获取联系人姓名，id
                            Cursor cursor = context.getApplicationContext().getContentResolver().query(contactData, null, null, null, null);
                            cursor.moveToFirst();
                            String username = cursor.getString(cursor.getColumnIndex(ContactsContract.Contacts.DISPLAY_NAME));
                            String contactId = cursor.getString(cursor.getColumnIndex(ContactsContract.Contacts._ID));
                            cursor.close();

                            // 根据id获取联系人电话
                            Cursor phoneCursor = contentResolver.query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, null,
                                    "_id = " + contactId, null, null, null);
                            String usernumber1 = null;
                            while (phoneCursor.moveToNext()) {
                                usernumber1 = phoneCursor.getString(phoneCursor.getColumnIndex(ContactsContract.CommonDataKinds.Phone.NUMBER));
                            }
                            phoneCursor.close();
                            if (!TextUtils.isEmpty(username) && !TextUtils.isEmpty(usernumber1)) {
                                listener.success(username, usernumber1);
                            }
                            else {
                                listener.fail("cannot support your android os");
                            }

                        }
                    }
                });
    }

    public interface ContactListener{
        public void success(String name, String phone);
        public void fail(String msg);
    }
}
