package com.tts.android.aopmonitor.aspect;

import com.google.gson.Gson;
import com.tts.android.aopmonitor.RecordService;
import com.tts.android.aopmonitor.bean.CrashRecordBean;
import com.tts.android.aopmonitor.common.CommonInit;
import com.tts.android.aopmonitor.tools.LogUtils;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

import java.lang.reflect.Method;

/**
 * AOP捕获异常的方法，发送异常数据到服务器
 * @author shijianting
 * 2018/11/8 3:25 PM
 */
@Aspect
public class UnCatchExAspect {

    @Pointcut("execution(@com.tts.android.aopmonitor.annotation.BindUnCatchEx * *(..))")
    public void unCatchExMethod(){}

    @After("unCatchExMethod()")
    public void crashCollect(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature) point.getSignature();
        Method method = methodSignature.getMethod();
        Thread thread = null;
        Throwable throwable = null;
        //方法中携带的所有参数
        Object[] args = point.getArgs();
        if (args.length == 2) {
            if (args[0] instanceof Thread && args[1] instanceof Throwable) {
                thread = (Thread) args[0];
                throwable = (Throwable) args[1];
            }
        }
        if (null != thread && null != throwable) {
            CrashRecordBean crashRecordBean = new CrashRecordBean();
            CommonInit.initBaseRecordBean(crashRecordBean);
            crashRecordBean.setCrashMsg(throwable.getMessage());
            StringBuilder exResult = new StringBuilder();
            for (StackTraceElement element: throwable.getStackTrace()
                 ) {
                exResult.append(element.toString());
                exResult.append("\n");
            }
            crashRecordBean.setCrashStackTrace(exResult.toString());
            LogUtils.logjson(new Gson().toJson(crashRecordBean));
        }
        else {
            LogUtils.logd("method param type is wrong");
        }
    }
}
