package com.tts.android.aopmonitor.aspect;

import android.os.Handler;
import android.text.Editable;
import android.text.TextUtils;


import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class MultiInputAspect {

    /**
     * 两次输入的时间间隔
     */
    private final int DURING = 800;


    /**
     * 用来保存的输入框内容
     */
    private static Editable content = null;

    /**
     * 执行方法的runnable
     */
    private SearchManager searchManager = new SearchManager();

    /**
     * handler,处理延时
     */
    Handler mHandler = new Handler();


    /**
     * 切入位置
     */
    private final String POINT_CONTENT = "execution(@com.tts.android.aopmonitor.annotation.BindMultiInput * *(..))";

    @Pointcut(POINT_CONTENT)
    public void multiInput(){}

    @Around("multiInput()")
    public void multiClickAround(ProceedingJoinPoint point) throws Throwable{

        Object[] args = point.getArgs();

        if (args.length == 0) {
            point.proceed();
            return;
        }

        Object arg = null;

        /**
         * 遍历参数，取出Editable类型参数
         */
        for (Object object :args) {
            if (object instanceof Editable) {
                arg = object;
            }
        }

        /**
         * 没有符合类型的参数，则直接执行方法内部代码
         */
        if (null == arg) {
            point.proceed();
            return;
        }

        content = (Editable) arg;

        /**
         * 如果内容为空，直接执行内容方法
         * 防止代码中对空值有特殊处理的时候，由于AOP处理导致的未知问题
         */
        if (TextUtils.isEmpty(content.toString())) {
            point.proceed();
        }
        else {
            //清除原队列中的runnable
            mHandler.removeCallbacks(searchManager);
            //动态匹配请求线程类
//            searchManager = new SearchManager();
            searchManager.point = point;
            mHandler.postDelayed(searchManager, DURING);
        }
    }




    /**
     * 执行方法内部
     */
    public class SearchManager implements Runnable {

        public ProceedingJoinPoint point;

        @Override
        public void run() {
            try {
                point.proceed();
            } catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}
