package com.tts.android.aopmonitor.aspect;

import com.tts.android.aopmonitor.tools.Constants;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.android.aopmonitor.tools.MultipleClickLimitUtils;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class MultiClickAspect {

    /**
     * 切入位置
     */
    private final String POINT_CONTENT = "execution(@com.tts.android.aopmonitor.annotation.BindMultiClick * *(..))";

    @Pointcut(POINT_CONTENT)
    public void multiClick(){}

    @Around("multiClick()")
    public void multiClickAround(ProceedingJoinPoint point) throws Throwable{

        if (!MultipleClickLimitUtils.isDoubleClick(Constants.options.getMultiClickDuring())) {
            point.proceed();
        }
        else {
            LogUtils.logd("这是一次重复点击");
        }
    }
}
