package com.tts.android.aopmonitor.actmanager;

import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.util.SparseArray;

public class StartCallbackFragment extends Fragment {

    /**
     * 存放 Callback
     */
    private SparseArray<ActivityResultCallBack> mCallbackArr;

    public StartCallbackFragment() {
        mCallbackArr = new SparseArray<>();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRetainInstance(true);
    }

    /**
     * StartCallbackFragment 开启目标 Activity
     *
     * @param intent      意图
     * @param requestCode 请求码
     * @param callback    回调
     */
    public void startForResult(Intent intent, int requestCode,
                               ActivityResultCallBack callback) {
        mCallbackArr.put(requestCode, callback);
        startActivityForResult(intent, requestCode);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        // Callback 结果回调
        ActivityResultCallBack callback = mCallbackArr.get(requestCode);
        if (callback == null) {
            return;
        }
        // 移除 Callback
        mCallbackArr.remove(requestCode);
        if (data == null) {
            // 回调错误方法
            callback.onResultError();
            return;
        }
        // 结果回调
        callback.onActivityResult(resultCode, data);
    }

}
