/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor;

import android.content.Context;
import android.content.Intent;
import com.google.gson.Gson;
import com.tts.android.aopmonitor.AOPOptions;
import com.tts.android.aopmonitor.RecordService;
import com.tts.android.aopmonitor.aspect.ClickRecordAspect;
import com.tts.android.aopmonitor.bean.InitRecordBean;
import com.tts.android.aopmonitor.net.NetManager;
import com.tts.android.aopmonitor.net.bean.RecordRequestBean;
import com.tts.android.aopmonitor.options.MoniterOption;
import com.tts.android.aopmonitor.tools.Constants;
import com.tts.android.aopmonitor.tools.CtwUtils;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.android.aopmonitor.tools.StringUtils;

public class AOPMonitor {
    private static Context mContext;

    public static void init(Context context) {
        mContext = context.getApplicationContext();
        Constants.random32String = StringUtils.getRandomString(32);
        LogUtils.initLogger();
    }

    public static void init(Context context, AOPOptions options) {
        AOPMonitor.init(context);
        Constants.options = options;
    }

    @Deprecated
    public static <T extends InitRecordBean> void initRecordData(T bean) {
        if (bean instanceof InitRecordBean) {
            Constants.initRecord = new Gson().toJson((Object)CtwUtils.initCtwRecordBean(bean));
        }
    }

    public static void setOption(AOPOptions options) {
        Constants.options = options;
    }

    public static void setMonitorOption(MoniterOption option) {
        Constants.moniterOption = option;
    }

    public static void startRecordService() {
        if (null != mContext) {
            Intent intent = new Intent(mContext, RecordService.class);
            mContext.startService(intent);
        }
    }

    public static void stopRecordService() {
        if (null != mContext) {
            Intent intent = new Intent(mContext, RecordService.class);
            mContext.stopService(intent);
        }
    }

    public static void setEnableMonitor(boolean enabled) {
        Constants.enabledMonitor = enabled;
    }

    public static void onResume(Context context) {
        String name = ClickRecordAspect.getPageName(context);
        RecordRequestBean bean = new RecordRequestBean();
        bean = RecordService.initBaseRecordBean(bean);
        bean.setPageId(name);
        String actionStr = new Gson().toJson((Object)CtwUtils.initCtwRecordBean(bean));
        new NetManager(context).doRecord(actionStr);
    }

    public static void onDestroy(Context context) {
    }
}

