package com.tts.android.aopmonitor.aspect;

import com.google.gson.Gson;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.android.aopmonitor.tools.TimeUtils;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

import java.lang.reflect.Method;

@Aspect
public class MethodAnalysisAspect {

    /**
     * 切入位置
     */
    private final String POINT_CONTENT = "execution(@com.tts.android.aopmonitor.annotation.BindAnalysis * *(..))";

    @Pointcut(POINT_CONTENT)
    public void analysis(){}

    @Around("analysis()")
    public Object analysisAround(ProceedingJoinPoint point) throws Throwable{

        MethodSignature methodSignature = (MethodSignature) point.getSignature();
        Method method = methodSignature.getMethod();
        //获取方法名称
        String methodName = "unknown method";
        if (null == method) {
            methodName = method.getName();
        }
        else {
            LogUtils.loge("can't get the method by reflect");
        }
        //获取方法所在类的名称（全名称）
        String className = method.getDeclaringClass().getName();
        String startTime = TimeUtils.getCurrentDateTimeHS();
        Object o = point.proceed();
        String endTime = TimeUtils.getCurrentDateTimeHS();
        long between = TimeUtils.getTimeHSBetween(startTime, endTime);
        String result = new Gson().toJson(new AnalysisInfo(className, methodName, startTime, endTime, between+"ms"));
        LogUtils.logjson(result);
        return o;
    }

    /**
     * 分析结果信息对象
     */
    public static class AnalysisInfo {
        private String className;
        private String methodName;
        private String startTime;
        private String endTime;
        private String during;

        public AnalysisInfo(String className, String methodName, String startTime, String endTime, String during) {
            this.className = className;
            this.methodName = methodName;
            this.startTime = startTime;
            this.endTime = endTime;
            this.during = during;
        }

        public String getClassName() {
            return className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getMethodName() {
            return methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getStartTime() {
            return startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public String getDuring() {
            return during;
        }

        public void setDuring(String during) {
            this.during = during;
        }
    }
}
