/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor.tools;

import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.blankj.utilcode.util.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileUtil {
    public static String external = Environment.getExternalStorageDirectory().getAbsolutePath();

    public static boolean createLogInEx(String fileName) {
        boolean isSuccess = FileUtils.createOrExistsFile((String)(external + "/" + fileName + ".log"));
        return isSuccess;
    }

    public static void writeStringInFile(String fileName, String content) {
        if (FileUtil.createLogInEx(fileName)) {
            FileUtil.writeFileToSDCard(content.getBytes(), fileName, true, true);
        }
    }

    public static synchronized void writeFileToSDCard(final @NonNull byte[] buffer, final @Nullable String fileName, final boolean append, final boolean autoLine) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File file = new File(external + "/" + fileName + ".log");
                RandomAccessFile raf = null;
                FileOutputStream out = null;
                try {
                    if (append) {
                        raf = new RandomAccessFile(file, "rw");
                        raf.seek(file.length());
                        raf.write(buffer);
                        if (autoLine) {
                            raf.write("\n".getBytes());
                        }
                    } else {
                        out = new FileOutputStream(file);
                        out.write(buffer);
                        out.flush();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (raf != null) {
                            raf.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }
}

