/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor.net;

import android.content.Context;
import android.text.TextUtils;
import com.blankj.utilcode.util.CacheDiskUtils;
import com.tts.android.aopmonitor.net.RequestRecord;
import com.tts.android.aopmonitor.options.MoniterOption;
import com.tts.android.aopmonitor.tools.Constants;
import com.tts.android.aopmonitor.tools.FileUtil;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.android.aopmonitor.tools.PropertiesUtil;
import com.tts.android.aopmonitor.tools.TimeUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class NetManager {
    Context mContext;
    public static int diskCacheId = 0;
    String baseUrl = Constants.moniterOption.getUrl();
    Retrofit retrofit;

    public NetManager(SoftReference<Context> context) {
        this.mContext = context.get();
        this.initRetrofit();
    }

    public NetManager(Context context) {
        this.mContext = context.getApplicationContext();
        this.initRetrofit();
    }

    private void initRetrofit() {
        this.retrofit = new Retrofit.Builder().baseUrl(this.baseUrl).addConverterFactory(new Converter.Factory(){

            public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
                return new Converter<ResponseBody, String>(){

                    public String convert(ResponseBody value) throws IOException {
                        return value.string();
                    }
                };
            }
        }).build();
    }

    public void doRecord(final String actions) {
        if (TextUtils.isEmpty((CharSequence)this.baseUrl) || TextUtils.isEmpty((CharSequence)Constants.moniterOption.getDataKey())) {
            return;
        }
        RequestRecord requestRecord = (RequestRecord)this.retrofit.create(RequestRecord.class);
        HashMap<String, String> params = this.initDefaultMParams();
        params.put("data", actions);
        Call<String> call = null;
        if (Constants.moniterOption.isDishCache()) {
            LogUtils.logd("write to Monitor file");
            FileUtil.writeStringInFile("Monitor", actions);
        }
        if ("ctw".equals(Constants.moniterOption.getDataKey())) {
            String url = Constants.moniterOption.getUrl() + Constants.moniterOption.getCmd() + "?" + actions;
            OkHttpClient client = new OkHttpClient.Builder().retryOnConnectionFailure(true).connectTimeout(15L, TimeUnit.SECONDS).build();
            Request request = new Request.Builder().url(url).get().build();
            okhttp3.Call callctw = client.newCall(request);
            LogUtils.logd(url);
            LogUtils.logjson(actions);
            callctw.enqueue(new okhttp3.Callback(){

                public void onFailure(okhttp3.Call call, IOException e) {
                    LogUtils.logd(e.getMessage());
                    NetManager.this.saveRecordInDiskCache(actions);
                }

                public void onResponse(okhttp3.Call call, Response response) throws IOException {
                    LogUtils.logd(response.message());
                }
            });
            return;
        }
        LogUtils.logjson(actions);
        if (Constants.moniterOption.getRequestType() == MoniterOption.REQUESTTYPE_POST) {
            call = requestRecord.postActionSend(Constants.moniterOption.getCmd(), params);
        } else if (Constants.moniterOption.getRequestType() == MoniterOption.REQUESTTYPE_GET) {
            call = requestRecord.getActionSend(Constants.moniterOption.getCmd(), params);
        } else {
            return;
        }
        call.enqueue((Callback)new Callback<String>(){

            public void onResponse(Call<String> call, retrofit2.Response<String> response) {
                LogUtils.logd((String)response.body());
            }

            public void onFailure(Call<String> call, Throwable t) {
                LogUtils.logd(t.getMessage());
                NetManager.this.saveRecordInDiskCache(actions);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRecordInDiskCache(String actions) {
        LogUtils.logd("save action in disk cache r" + diskCacheId);
        CacheDiskUtils.getInstance().put("r" + diskCacheId, actions);
        NetManager netManager = this;
        synchronized (netManager) {
            ++diskCacheId;
        }
    }

    @Deprecated
    private String disguiseParamNames(String paramJson) {
        String newParamJson = paramJson;
        HashMap<String, String> recordKeyMap = PropertiesUtil.getAllProperties(this.mContext, "recordKeyMap");
        if (recordKeyMap.size() > 0) {
            for (Map.Entry<String, String> entry : recordKeyMap.entrySet()) {
                newParamJson = newParamJson.replace(entry.getKey(), entry.getValue());
            }
        }
        return newParamJson;
    }

    private HashMap<String, String> initDefaultMParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("flowCode", Constants.random32String);
        params.put("timeStamp", TimeUtils.getTimeStamp());
        params.put("appVersionCode", "-1");
        return params;
    }
}

