package com.tts.android.aopmonitor.options;

/**
 * 监控功能的配置
 * @author shijianting
 * 2018/9/2 上午9:26
 */
public class MoniterOption {

    public static int REQUESTTYPE_POST = 1;
    public static int REQUESTTYPE_GET = 2;

    /**
     * 监控数据发送地址,url需要已"/"结尾，retrofit2特性
     */
    private String url;

    /**
     * url后面具体地址内容
     * 如：url为http://www.changtu.com/
     * cmd为test.php
     * 完成的请求url为http://www.changtu.com/test.php
     */
    private String cmd;

    /**
     * 监控数据请求方式
     */
    private int requestType = REQUESTTYPE_POST;

    /**
     * 累计发送条数
     */
    private int actionCount = 1;

    /**
     * 是否使用磁盘缓存记录
     * 生产环境关闭，影响性能
     */
    private boolean dishCache = false;

    /**
     * 发送监控数据时，存储数据的key名称，默认为data
     * http://www.changtu.com/test.php?data={……}
     * 如果配置为ctw，使用畅途网专用网络格式
     */
    private String dataKey = "data";

    public static class Builder{

        MoniterOption target;

        public Builder() {
            target = new MoniterOption();
        }

        public MoniterOption.Builder debug() {
            return this;
        }

        public Builder url(String url) {
            target.url = url;
            return this;
        }

        public Builder cmd(String cmd) {
            target.cmd = cmd;
            return this;
        }

        public Builder requestType(int type) {
            target.requestType = type;
            return this;
        }

        public Builder actionCount(int count) {
            target.actionCount = count;
            return this;
        }

        public Builder dataKey(String dataKey) {
            target.dataKey = dataKey;
            return this;
        }

        public Builder dishCache(boolean dishCache) {
            target.dishCache = dishCache;
            return this;
        }

        public MoniterOption build() {
            return target;
        }
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getRequestType() {
        return requestType;
    }

    public void setRequestType(int requestType) {
        this.requestType = requestType;
    }

    public int getActionCount() {
        return actionCount;
    }

    public void setActionCount(int actionCount) {
        this.actionCount = actionCount;
    }

    public String getDataKey() {
        return dataKey;
    }

    public void setDataKey(String dataKey) {
        this.dataKey = dataKey;
    }

    public String getCmd() {
        return cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public boolean isDishCache() {
        return dishCache;
    }

    public void setDishCache(boolean dishCache) {
        this.dishCache = dishCache;
    }
}
