/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor.aspect;

import com.google.gson.Gson;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.android.aopmonitor.tools.TimeUtils;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class MethodAnalysisAspect {
    private final String POINT_CONTENT = "execution(@com.tts.android.aopmonitor.annotation.BindAnalysis * *(..))";

    @Pointcut(value="execution(@com.tts.android.aopmonitor.annotation.BindAnalysis * *(..))")
    public void analysis() {
    }

    @Around(value="analysis()")
    public Object analysisAround(ProceedingJoinPoint point) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        String methodName = "unknown method";
        if (null == method) {
            methodName = method.getName();
        } else {
            LogUtils.loge("can't get the method by reflect");
        }
        String className = method.getDeclaringClass().getName();
        String startTime = TimeUtils.getCurrentDateTimeHS();
        Object o = point.proceed();
        String endTime = TimeUtils.getCurrentDateTimeHS();
        long between = TimeUtils.getTimeHSBetween(startTime, endTime);
        String result = new Gson().toJson((Object)new AnalysisInfo(className, methodName, startTime, endTime, between + "ms"));
        LogUtils.logjson(result);
        return o;
    }

    public static class AnalysisInfo {
        private String className;
        private String methodName;
        private String startTime;
        private String endTime;
        private String during;

        public AnalysisInfo(String className, String methodName, String startTime, String endTime, String during) {
            this.className = className;
            this.methodName = methodName;
            this.startTime = startTime;
            this.endTime = endTime;
            this.during = during;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public String getDuring() {
            return this.during;
        }

        public void setDuring(String during) {
            this.during = during;
        }
    }
}

