package com.tts.android.aopmonitor.common;

import android.annotation.SuppressLint;
import android.os.Build;

import com.blankj.utilcode.util.AppUtils;
import com.blankj.utilcode.util.DeviceUtils;
import com.blankj.utilcode.util.PhoneUtils;
import com.tts.android.aopmonitor.net.bean.BaseRequestBean;
import com.tts.android.aopmonitor.tools.Constants;
import com.tts.android.aopmonitor.tools.TimeUtils;

public class CommonInit {

    @SuppressLint("MissingPermission")
    public static void initBaseRecordBean(BaseRequestBean bean) {
        bean.setAppVersionCode(AppUtils.getAppVersionCode()+"");
        bean.setAppVersionName(AppUtils.getAppVersionName());
        bean.setFlowCode(Constants.random32String);
        bean.setUniqueId(PhoneUtils.getDeviceId());
        bean.setTimeStamp(TimeUtils.getTimeStamp());
        bean.setOrderSource("android");
        bean.setChannel("7");
        bean.setUserId(Constants.userId);
        bean.setSystemVersion(DeviceUtils.getSDKVersionName());
        bean.setManufacturer(Build.MANUFACTURER);
        bean.setModel(Build.MODEL);
        bean.setResolution(Build.DISPLAY);
    }
}
