package com.tts.android.aopmonitor.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 处理连续输入的，导致TextView watcher方法执行太频繁的问题。
 * 原理： 快速输入后，只保留最后一次文本内容状态，进行内部方法调用
 * @author shijianting
 * 2018/12/20 10:48 AM
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface BindMultiInput {

}
