/*
 * Decompiled with CFR 0.152.
 */
package com.trycath.myupdateapklibrary.util;

import android.os.Environment;
import android.util.Log;
import com.trycath.myupdateapklibrary.UpdateKey;
import com.trycath.myupdateapklibrary.model.AppInfoModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtils {
    private static final String TAG = "FileUtils";

    public static byte[] readStreamToBytes(InputStream in) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int length = -1;
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
        out.flush();
        byte[] result = out.toByteArray();
        in.close();
        out.close();
        return result;
    }

    public static void writeFile(InputStream in, File file) throws IOException {
        Log.d((String)TAG, (String)"write file=====start==");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file != null && file.exists()) {
            file.delete();
        }
        FileOutputStream out = new FileOutputStream(file);
        byte[] buffer = new byte[131072];
        int len = -1;
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        Log.d((String)TAG, (String)"write file====success===");
        out.flush();
        out.close();
        in.close();
    }

    public static long getFileSize(File file) {
        if (file.exists() && file.isFile()) {
            return file.length();
        }
        return 0L;
    }

    public static File getFile(AppInfoModel appInfoModel) {
        if (appInfoModel == null) {
            return null;
        }
        String fileName = "";
        fileName = UpdateKey.DOWNLOAD_APK_NAME != null && !"".equals(UpdateKey.DOWNLOAD_APK_NAME) ? String.format("%s_%s.apk", UpdateKey.DOWNLOAD_APK_NAME, appInfoModel.getVersionShort()) : String.format("%s_%s.apk", appInfoModel.getName(), appInfoModel.getVersionShort());
        return new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS), fileName);
    }
}

