/*
 * Decompiled with CFR 0.152.
 */
package com.trycath.myupdateapklibrary.rxbus;

import com.trycath.myupdateapklibrary.rxbus.RxBusResult;
import java.util.HashMap;
import java.util.Map;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action1;
import rx.schedulers.Schedulers;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class RxBus {
    private static final String TAG = "RxBus";
    private final Subject<Object, Object> _bus = new SerializedSubject((Subject)PublishSubject.create());
    private final Map<String, Object> tags = new HashMap<String, Object>();
    private final Map<String, Object> sendtags = new HashMap<String, Object>();
    private static RxBus rxbus;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RxBus getInstance() {
        if (rxbus != null) return rxbus;
        Class<RxBus> clazz = RxBus.class;
        synchronized (RxBus.class) {
            if (rxbus != null) return rxbus;
            rxbus = new RxBus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return rxbus;
        }
    }

    public void post(String tag, Object object) {
        if (!this.tags.containsKey(tag)) {
            this.tags.put(tag, object);
            this._bus.onNext(object);
            this.sendtags.put(tag, object);
        } else {
            this.tags.remove(tag);
            this.tags.put(tag, object);
            this._bus.onNext(object);
            this.sendtags.put(tag, object);
        }
    }

    public void toObserverableOnMainThread(final String tag, final RxBusResult rxBusResult) {
        this._bus.onBackpressureDrop().observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Object>(){

            public void call(Object o) {
                if (RxBus.this.sendtags.containsKey(tag)) {
                    rxBusResult.onRxBusResult(RxBus.this.sendtags.get(tag));
                }
            }
        });
    }

    public void toObserverableChildThread(final String tag, final RxBusResult rxBusResult) {
        this._bus.onBackpressureDrop().observeOn(Schedulers.io()).subscribe((Action1)new Action1<Object>(){

            public void call(Object o) {
                if (RxBus.this.sendtags.containsKey(tag)) {
                    rxBusResult.onRxBusResult(RxBus.this.sendtags.get(tag));
                }
            }
        });
    }

    public void removeObserverable(String tag) {
        if (this.tags.containsKey(tag)) {
            this.tags.remove(tag);
        }
        if (this.sendtags.containsKey(tag)) {
            this.sendtags.remove(tag);
        }
    }

    public void release() {
        this.tags.clear();
        this.sendtags.clear();
        rxbus = null;
    }
}

