/*
 * Decompiled with CFR 0.152.
 */
package com.trycath.myupdateapklibrary.listener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.trycath.myupdateapklibrary.UpdateKey;
import com.trycath.myupdateapklibrary.listener.HttpClientHelper;
import com.trycath.myupdateapklibrary.listener.ProgressResponseListener;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class ServiceGenerator {
    private static final String HOST = UpdateKey.BASE_URL;
    private static Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").serializeNulls().create();
    private static Retrofit.Builder builder = new Retrofit.Builder().baseUrl(HOST).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create());

    public static <T> T createService(Class<T> tClass) {
        return (T)builder.client(HttpClientHelper.getOkhttp()).build().create(tClass);
    }

    public static <T> T createResponseService(Class<T> tClass, ProgressResponseListener listener) {
        return (T)builder.client(HttpClientHelper.addProgressResponseListener(listener)).build().create(tClass);
    }
}

