/*
 * Decompiled with CFR 0.152.
 */
package com.trycath.myupdateapklibrary;

import android.content.Context;
import android.util.Log;
import com.trycath.myupdateapklibrary.UpdateKey;
import com.trycath.myupdateapklibrary.dialogactivity.PromptDialogActivity;
import com.trycath.myupdateapklibrary.httprequest.DownloadServiceApi;
import com.trycath.myupdateapklibrary.listener.AppUpdateListener;
import com.trycath.myupdateapklibrary.listener.ServiceGenerator;
import com.trycath.myupdateapklibrary.model.AppInfoModel;
import com.trycath.myupdateapklibrary.util.GetAppInfo;
import com.trycath.myupdateapklibrary.util.IntenetUtil;
import com.trycath.myupdateapklibrary.util.PreferenceUtils;
import java.util.concurrent.TimeUnit;
import rx.Subscriber;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;

public class UpdateApk {
    private static final String TAG = "UpdateApk";
    private static volatile UpdateApk sInst = null;
    private static volatile Subscription subscription;
    private static Context mContext;
    private static AppUpdateListener appUpdateListener;
    private static boolean mManualUpdateFlg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdateApk init(Context context) {
        UpdateApk inst = sInst;
        if (inst == null) {
            Class<UpdateApk> clazz = UpdateApk.class;
            synchronized (UpdateApk.class) {
                inst = sInst;
                if (inst == null) {
                    mContext = context;
                    sInst = inst = new UpdateApk(context);
                } else {
                    sInst.update();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            sInst.update();
        }
        return inst;
    }

    public static void setAppUpdateListener(AppUpdateListener listener) {
        appUpdateListener = listener;
    }

    public static void setmManualUpdateFlg(boolean mManualUpdateFlg) {
        UpdateApk.mManualUpdateFlg = mManualUpdateFlg;
    }

    public static void setmManualUpdate(boolean mManualUpdateFlg, AppUpdateListener listener) {
        UpdateApk.mManualUpdateFlg = mManualUpdateFlg;
        appUpdateListener = listener;
    }

    private UpdateApk(Context context) {
        Log.d((String)TAG, (String)TAG);
        this.update();
    }

    private void update() {
        Log.d((String)TAG, (String)"GETAPPINFO");
        if (UpdateKey.DOWNLOAD_WIFI) {
            switch (IntenetUtil.getNetworkState(mContext)) {
                case 0: {
                    Log.d((String)TAG, (String)"IntenetUtil.NETWORN_NONE");
                    break;
                }
                case 2: {
                    Log.d((String)TAG, (String)"IntenetUtil.NETWORN_2G");
                    break;
                }
                case 3: {
                    Log.d((String)TAG, (String)"IntenetUtil.NETWORN_3G");
                    break;
                }
                case 4: {
                    Log.d((String)TAG, (String)"IntenetUtil.NETWORN_4G");
                    break;
                }
                case 5: {
                    Log.d((String)TAG, (String)"IntenetUtil.NETWORN_MOBILE");
                    break;
                }
                case 1: {
                    Log.d((String)TAG, (String)"IntenetUtil.NETWORN_WIFI");
                    this.getAppinfo();
                    break;
                }
            }
        } else {
            this.getAppinfo();
        }
    }

    public void getAppinfo() {
        DownloadServiceApi downloadService = ServiceGenerator.createService(DownloadServiceApi.class);
        subscription = downloadService.getUpdateApkInfo(UpdateKey.APP_ID, UpdateKey.API_TOKEN).delaySubscription(1L, TimeUnit.SECONDS).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<AppInfoModel>(){

            public void onStart() {
                super.onStart();
                if (appUpdateListener != null) {
                    appUpdateListener.onStart();
                }
            }

            public void onCompleted() {
                if (appUpdateListener != null) {
                    appUpdateListener.onCompleted();
                }
                mManualUpdateFlg = false;
            }

            public void onError(Throwable e) {
                Log.d((String)UpdateApk.TAG, (String)e.toString());
                if (appUpdateListener != null) {
                    appUpdateListener.onError(e);
                }
                mManualUpdateFlg = false;
            }

            public void onNext(AppInfoModel appInfoModel) {
                Log.d((String)UpdateApk.TAG, (String)appInfoModel.toString());
                if (appUpdateListener != null) {
                    appUpdateListener.onNext(appInfoModel);
                }
                UpdateApk.this.valAppInfo(appInfoModel);
                mManualUpdateFlg = false;
            }
        });
    }

    public void valAppInfo(AppInfoModel appInfoModel) {
        if (appInfoModel.getVersion() != null && (!PreferenceUtils.getPrefBoolean(mContext, appInfoModel.getVersion(), false) || mManualUpdateFlg)) {
            switch (GetAppInfo.compareVersionCode(GetAppInfo.getVersionCode(mContext), Integer.parseInt(appInfoModel.getVersion()))) {
                case 0: {
                    Log.d((String)TAG, (String)"this is best new version");
                    if (appUpdateListener == null) break;
                    appUpdateListener.onNext(appInfoModel, 0);
                    break;
                }
                case 1: {
                    Log.d((String)TAG, (String)"this is highest version");
                    if (appUpdateListener == null) break;
                    appUpdateListener.onNext(appInfoModel, 1);
                    break;
                }
                case -1: {
                    Log.d((String)TAG, (String)"need update new version");
                    PromptDialogActivity.startActivity(mContext, appInfoModel);
                    if (appUpdateListener == null) break;
                    appUpdateListener.onNext(appInfoModel, -1);
                    break;
                }
            }
        }
    }

    public static void destory() {
        if (sInst != null) {
            sInst = null;
        }
        if (mContext != null) {
            mContext = null;
        }
        if (subscription != null && !subscription.isUnsubscribed()) {
            subscription.unsubscribe();
            subscription = null;
        }
        if (appUpdateListener != null) {
            appUpdateListener = null;
        }
    }

    static {
        appUpdateListener = null;
        mManualUpdateFlg = false;
    }
}

