/*
 * Decompiled with CFR 0.152.
 */
package com.trycath.myupdateapklibrary.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

public class PreferenceUtils {
    public static String getPrefString(Context context, String key, String defaultValue) {
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return settings.getString(key, defaultValue);
    }

    public static void setPrefString(Context context, String key, String value) {
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)context);
        settings.edit().putString(key, value).commit();
    }

    public static boolean getPrefBoolean(Context context, String key, boolean defaultValue) {
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return settings.getBoolean(key, defaultValue);
    }

    public static boolean hasKey(Context context, String key) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context).contains(key);
    }

    public static void setPrefBoolean(Context context, String key, boolean value) {
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)context);
        settings.edit().putBoolean(key, value).commit();
    }

    public static void setPrefInt(Context context, String key, int value) {
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)context);
        settings.edit().putInt(key, value).commit();
    }

    public static int getPrefInt(Context context, String key, int defaultValue) {
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return settings.getInt(key, defaultValue);
    }

    public static void setPrefFloat(Context context, String key, float value) {
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)context);
        settings.edit().putFloat(key, value).commit();
    }

    public static float getPrefFloat(Context context, String key, float defaultValue) {
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return settings.getFloat(key, defaultValue);
    }

    public static void setSettingLong(Context context, String key, long value) {
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)context);
        settings.edit().putLong(key, value).commit();
    }

    public static long getPrefLong(Context context, String key, long defaultValue) {
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return settings.getLong(key, defaultValue);
    }

    public static void clearPreference(Context context, SharedPreferences p) {
        SharedPreferences.Editor editor = p.edit();
        editor.clear();
        editor.commit();
    }
}

