/*
 * Decompiled with CFR 0.152.
 */
package com.trycath.myupdateapklibrary.service;

import android.app.IntentService;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.trycath.myupdateapklibrary.R;
import com.trycath.myupdateapklibrary.dialogactivity.ProgressBarActivity;
import com.trycath.myupdateapklibrary.exception.CustomizeException;
import com.trycath.myupdateapklibrary.httprequest.DownloadServiceApi;
import com.trycath.myupdateapklibrary.listener.ProgressResponseListener;
import com.trycath.myupdateapklibrary.listener.ServiceGenerator;
import com.trycath.myupdateapklibrary.model.AppInfoModel;
import com.trycath.myupdateapklibrary.model.DownloadModel;
import com.trycath.myupdateapklibrary.rxbus.RxBus;
import com.trycath.myupdateapklibrary.rxbus.RxBusResult;
import com.trycath.myupdateapklibrary.util.FileUtils;
import com.trycath.myupdateapklibrary.util.GetAppInfo;
import com.trycath.myupdateapklibrary.util.InstallApk;
import com.trycath.myupdateapklibrary.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import okhttp3.ResponseBody;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func1;

public class DownloadService
extends IntentService
implements ProgressResponseListener {
    private static final String TAG = "DownloadService";
    private NotificationCompat.Builder notificationBuilder;
    private NotificationManager notificationManager;
    private Subscription subscription;
    private RxBus rxBus = RxBus.getInstance();
    private AppInfoModel appInfoModel;

    public DownloadService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        Log.d((String)TAG, (String)"onHandleIntent");
        this.appInfoModel = (AppInfoModel)intent.getExtras().getSerializable("INTENT_DOWNLOAD_MODEL");
        this.notificationManager = (NotificationManager)this.getSystemService("notification");
        this.notificationBuilder = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)this.getResources().getString(R.string.file_downloading)).setSmallIcon(GetAppInfo.getAppIconId((Context)this)).setContentText((CharSequence)this.getResources().getString(R.string.file_downloading)).setTicker((CharSequence)this.getResources().getString(R.string.start_downloaded)).setAutoCancel(true);
        this.notificationManager.notify(0, this.notificationBuilder.build());
        this.coloseDownload();
        this.download();
    }

    private void download() {
        Log.d((String)TAG, (String)"download");
        ProgressBarActivity.startActivity((Context)this, this.appInfoModel);
        DownloadServiceApi downloadService = ServiceGenerator.createResponseService(DownloadServiceApi.class, this);
        this.subscription = downloadService.download(this.appInfoModel.getInstallUrl()).map((Func1)new Func1<ResponseBody, InputStream>(){

            public InputStream call(ResponseBody responseBody) {
                return responseBody.byteStream();
            }
        }).doOnNext((Action1)new Action1<InputStream>(){

            public void call(InputStream inputStream) {
                try {
                    FileUtils.writeFile(inputStream, FileUtils.getFile(DownloadService.this.appInfoModel));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new CustomizeException(e.getMessage(), e);
                }
            }
        }).subscribe((Subscriber)new Subscriber<InputStream>(){

            public void onCompleted() {
                DownloadService.this.downloadCompleted();
            }

            public void onError(Throwable e) {
                DownloadService.this.downloadCompleted();
                Log.d((String)DownloadService.TAG, (String)e.toString());
            }

            public void onNext(InputStream inputStream) {
            }
        });
    }

    private void downloadCompleted() {
        DownloadModel download = new DownloadModel();
        download.setProgress(100);
        this.sendIntent(download);
        this.notificationBuilder.setProgress(0, 0, false);
        this.notificationBuilder.setContentText((CharSequence)this.getResources().getString(R.string.file_downloaded));
        this.notificationManager.notify(0, this.notificationBuilder.build());
        Log.d((String)TAG, (String)"install apk............");
        InstallApk.startInstall((Context)this, FileUtils.getFile(this.appInfoModel));
    }

    private void sendNotification(DownloadModel download) {
        this.sendIntent(download);
        this.notificationBuilder.setProgress(100, download.getProgress(), false);
        this.notificationBuilder.setContentText((CharSequence)(StringUtils.getDataSize(download.getCurrentFileSize()) + "/" + StringUtils.getDataSize(download.getTotalFileSize())));
        this.notificationManager.notify(0, this.notificationBuilder.build());
    }

    private void sendIntent(DownloadModel download) {
        this.rxBus.post("MESSAGE_PROGRESS", download);
    }

    private void coloseDownload() {
        this.rxBus.toObserverableOnMainThread("MESSAGE_COLOSE", new RxBusResult(){

            @Override
            public void onRxBusResult(Object o) {
                String msg;
                Log.d((String)"RxBusResult", (String)"coloseDownload");
                if (o instanceof String && "MESSAGE_COLOSE".equals(msg = (String)o)) {
                    Log.d((String)"RxBusResult", (String)"ondestory");
                    DownloadService.this.onDestroy();
                }
            }
        });
    }

    public void onTaskRemoved(Intent rootIntent) {
        Log.d((String)TAG, (String)"onTaskRemoved");
        this.notificationManager.cancel(0);
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
        if (this.rxBus != null) {
            this.rxBus.release();
        }
    }

    public static void startDownloadService(Context context, AppInfoModel appInfoModel) {
        Log.d((String)TAG, (String)"startDownloadService");
        Intent intent = new Intent(context, DownloadService.class);
        intent.putExtra("INTENT_DOWNLOAD_MODEL", (Serializable)appInfoModel);
        context.startService(intent);
    }

    @Override
    public void onResponseProgress(long bytesRead, long contentLength, boolean done) {
        Log.d((String)TAG, (String)("onResponseProgress======done====>>" + done));
        DownloadModel download = new DownloadModel();
        download.setTotalFileSize(contentLength);
        download.setCurrentFileSize(bytesRead);
        int progress = (int)(bytesRead * 100L / contentLength);
        download.setProgress(progress);
        this.sendNotification(download);
    }

    public void onDestroy() {
        Log.d((String)TAG, (String)"onDestroy");
        super.onDestroy();
        if (this.subscription != null) {
            Log.d((String)TAG, (String)"subscription.isUnsubscribed()");
            this.subscription.unsubscribe();
        }
        if (this.rxBus != null) {
            Log.d((String)TAG, (String)"rxBus.release()");
            this.rxBus.release();
        }
        if (this.notificationManager != null) {
            Log.d((String)TAG, (String)"notificationManager.cancel(0)");
            this.notificationManager.cancel(0);
        }
    }
}

