/*
 * Decompiled with CFR 0.152.
 */
package com.trycath.myupdateapklibrary.dialogactivity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.trycath.myupdateapklibrary.R;
import com.trycath.myupdateapklibrary.UpdateKey;
import com.trycath.myupdateapklibrary.model.AppInfoModel;
import com.trycath.myupdateapklibrary.model.DownloadModel;
import com.trycath.myupdateapklibrary.rxbus.RxBus;
import com.trycath.myupdateapklibrary.rxbus.RxBusResult;
import com.trycath.myupdateapklibrary.util.StringUtils;
import java.io.Serializable;

public class ProgressBarActivity
extends AppCompatActivity {
    private ProgressBar downloaddialog_progress;
    private TextView downloaddialog_count;
    private TextView tv_title;
    private ImageView downloaddialog_close;
    public static final String TAG = ProgressBarActivity.class.getSimpleName();
    public static final String MESSAGE_PROGRESS = "MESSAGE_PROGRESS";
    public static final String MESSAGE_COLOSE = "MESSAGE_COLOSE";
    private RxBus rxBus = RxBus.getInstance();
    private AppInfoModel appInfoModel;
    View.OnClickListener onClickListenerDownLoadingClose = new View.OnClickListener(){

        public void onClick(View v) {
            Log.d((String)TAG, (String)"onClickListenerDownLoadingClose");
            ProgressBarActivity.this.rxBus.post(ProgressBarActivity.MESSAGE_COLOSE, ProgressBarActivity.MESSAGE_COLOSE);
            ProgressBarActivity.this.finish();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_progress_bar);
        Log.d((String)TAG, (String)"onCreate");
        if (this.getIntent() != null && this.getIntent().getExtras() != null && this.getIntent().getExtras().getSerializable("INTENT_DOWNLOAD_MODEL") != null) {
            this.appInfoModel = (AppInfoModel)this.getIntent().getExtras().getSerializable("INTENT_DOWNLOAD_MODEL");
            this.initView();
            this.initRxBusProgressDownload();
        } else {
            this.finish();
        }
    }

    private void initRxBusProgressDownload() {
        Log.d((String)TAG, (String)"initRxBusProgressDownload");
        this.rxBus.toObserverableOnMainThread(MESSAGE_PROGRESS, new RxBusResult(){

            @Override
            public void onRxBusResult(Object o) {
                if (o instanceof DownloadModel) {
                    DownloadModel download = (DownloadModel)o;
                    ProgressBarActivity.this.downloaddialog_progress.setProgress(download.getProgress());
                    if (download.getProgress() == 100) {
                        ProgressBarActivity.this.downloaddialog_count.setText((CharSequence)ProgressBarActivity.this.getResources().getString(R.string.download_successful));
                        ProgressBarActivity.this.finish();
                    } else {
                        ProgressBarActivity.this.downloaddialog_count.setText((CharSequence)(StringUtils.getDataSize(download.getCurrentFileSize()) + "/" + StringUtils.getDataSize(download.getTotalFileSize())));
                    }
                }
            }
        });
    }

    private void initView() {
        Log.d((String)TAG, (String)"initView");
        this.downloaddialog_progress = (ProgressBar)this.findViewById(R.id.downloaddialog_progress);
        this.downloaddialog_count = (TextView)this.findViewById(R.id.downloaddialog_count);
        this.downloaddialog_close = (ImageView)this.findViewById(R.id.downloaddialog_close);
        this.downloaddialog_close.setOnClickListener(this.onClickListenerDownLoadingClose);
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        if (UpdateKey.DOWNLOAD_NAME != null && !"".equals(UpdateKey.DOWNLOAD_NAME)) {
            this.tv_title.setText((CharSequence)String.format("%s%s", this.getResources().getString(R.string.is_downloading), UpdateKey.DOWNLOAD_NAME));
        } else {
            this.tv_title.setText((CharSequence)String.format("%s%s", this.getResources().getString(R.string.is_downloading), this.appInfoModel.getName()));
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        Log.d((String)TAG, (String)"onDestroy");
        if (this.rxBus != null) {
            this.rxBus.removeObserverable(MESSAGE_COLOSE);
        }
    }

    public static void startActivity(Context context, AppInfoModel appInfoModel) {
        Log.d((String)TAG, (String)"startActivity");
        Intent intent = new Intent(context, ProgressBarActivity.class);
        intent.putExtra("INTENT_DOWNLOAD_MODEL", (Serializable)appInfoModel);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        Log.d((String)TAG, (String)"onRestoreInstanceState");
        this.appInfoModel = (AppInfoModel)savedInstanceState.getSerializable("INTENT_DOWNLOAD_MODEL");
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Log.d((String)TAG, (String)"onSaveInstanceState");
        outState.putSerializable("INTENT_DOWNLOAD_MODEL", (Serializable)this.appInfoModel);
    }
}

