/*
 * Decompiled with CFR 0.152.
 */
package com.trycath.myupdateapklibrary.service;

import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.widget.Toast;
import com.trycath.myupdateapklibrary.R;
import com.trycath.myupdateapklibrary.UpdateKey;
import com.trycath.myupdateapklibrary.dialogactivity.ProgressBarActivity;
import com.trycath.myupdateapklibrary.exception.CustomizeException;
import com.trycath.myupdateapklibrary.httprequest.DownloadServiceApi;
import com.trycath.myupdateapklibrary.listener.ProgressResponseListener;
import com.trycath.myupdateapklibrary.listener.ServiceGenerator;
import com.trycath.myupdateapklibrary.model.AppInfoModel;
import com.trycath.myupdateapklibrary.model.DownloadModel;
import com.trycath.myupdateapklibrary.rxbus.RxBus;
import com.trycath.myupdateapklibrary.rxbus.RxBusResult;
import com.trycath.myupdateapklibrary.util.FileUtils;
import com.trycath.myupdateapklibrary.util.GetAppInfo;
import com.trycath.myupdateapklibrary.util.InstallApk;
import com.trycath.myupdateapklibrary.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import okhttp3.ResponseBody;
import rx.Subscriber;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class DownloadFileService
extends Service
implements ProgressResponseListener {
    private static final String TAG = "DownloadFileService";
    private NotificationCompat.Builder notificationBuilder;
    private NotificationManager notificationManager;
    private Subscription subscription;
    private RxBus rxBus = RxBus.getInstance();
    private AppInfoModel appInfoModel;

    @Nullable
    public IBinder onBind(Intent intent) {
        Log.d((String)TAG, (String)"onBind()");
        return null;
    }

    public void onCreate() {
        super.onCreate();
        Log.d((String)TAG, (String)"onCreate()");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.d((String)TAG, (String)"onStartCommand()");
        if (intent != null && intent.getExtras() != null && intent.getExtras().getSerializable("INTENT_DOWNLOAD_MODEL") != null) {
            this.appInfoModel = (AppInfoModel)intent.getExtras().getSerializable("INTENT_DOWNLOAD_MODEL");
            if (UpdateKey.WITH_NOTIFITION) {
                this.notificationManager = (NotificationManager)this.getSystemService("notification");
                this.notificationBuilder = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)this.getResources().getString(R.string.file_downloading)).setSmallIcon(GetAppInfo.getAppIconId((Context)this)).setContentText((CharSequence)this.getResources().getString(R.string.file_downloading)).setTicker((CharSequence)this.getResources().getString(R.string.start_downloaded)).setAutoCancel(true);
                this.notificationManager.notify(0, this.notificationBuilder.build());
            }
            this.coloseDownload();
            this.download();
        }
        return super.onStartCommand(intent, flags, startId);
    }

    public void onStart(Intent intent, int startId) {
        super.onStart(intent, startId);
        Log.d((String)TAG, (String)"onStart()");
    }

    private void download() {
        Log.d((String)TAG, (String)"download");
        if (UpdateKey.WITH_DIALOG) {
            ProgressBarActivity.startActivity((Context)this, this.appInfoModel);
        }
        DownloadServiceApi downloadService = ServiceGenerator.createResponseService(DownloadServiceApi.class, this);
        this.subscription = downloadService.download(this.appInfoModel.getInstallUrl()).subscribeOn(Schedulers.io()).unsubscribeOn(Schedulers.io()).map((Func1)new Func1<ResponseBody, InputStream>(){

            public InputStream call(ResponseBody responseBody) {
                return responseBody.byteStream();
            }
        }).observeOn(Schedulers.computation()).doOnNext((Action1)new Action1<InputStream>(){

            public void call(InputStream inputStream) {
                try {
                    FileUtils.writeFile(inputStream, FileUtils.getFile(DownloadFileService.this.appInfoModel));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new CustomizeException(e.getMessage(), e);
                }
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<InputStream>(){

            public void onCompleted() {
                Log.d((String)DownloadFileService.TAG, (String)"onCompleted()");
            }

            public void onError(Throwable e) {
                DownloadFileService.this.downloadCompleted();
                Log.d((String)DownloadFileService.TAG, (String)e.toString());
                Toast.makeText((Context)DownloadFileService.this, (CharSequence)DownloadFileService.this.getResources().getString(R.string.downloaded_field), (int)0).show();
            }

            public void onNext(InputStream inputStream) {
                InstallApk.startInstall((Context)DownloadFileService.this, FileUtils.getFile(DownloadFileService.this.appInfoModel));
                DownloadFileService.this.onDestroy();
            }
        });
    }

    private void downloadCompleted() {
        Log.d((String)TAG, (String)"downloadCompleted()");
        DownloadModel download = new DownloadModel();
        download.setProgress(100);
        this.sendIntent(download);
        if (UpdateKey.WITH_NOTIFITION) {
            this.notificationBuilder.setProgress(0, 0, false);
            this.notificationBuilder.setContentText((CharSequence)this.getResources().getString(R.string.file_downloaded));
            this.notificationManager.notify(0, this.notificationBuilder.build());
        }
    }

    private void sendNotification(DownloadModel download) {
        Log.d((String)TAG, (String)"sendNotification()");
        this.sendIntent(download);
        if (UpdateKey.WITH_NOTIFITION) {
            this.notificationBuilder.setProgress(100, download.getProgress(), false);
            this.notificationBuilder.setContentText((CharSequence)(StringUtils.getDataSize(download.getCurrentFileSize()) + "/" + StringUtils.getDataSize(download.getTotalFileSize())));
            this.notificationManager.notify(0, this.notificationBuilder.build());
        }
    }

    private void sendIntent(DownloadModel download) {
        Log.d((String)TAG, (String)"sendIntent()");
        this.rxBus.post("MESSAGE_PROGRESS", download);
    }

    private void coloseDownload() {
        Log.d((String)TAG, (String)"coloseDownload()");
        this.rxBus.toObserverableOnMainThread("MESSAGE_COLOSE", new RxBusResult(){

            @Override
            public void onRxBusResult(Object o) {
                String msg;
                Log.d((String)"RxBusResult", (String)"coloseDownload");
                if (o instanceof String && "MESSAGE_COLOSE".equals(msg = (String)o)) {
                    Log.d((String)"RxBusResult", (String)"ondestory");
                    DownloadFileService.this.onDestroy();
                }
            }
        });
    }

    @Override
    public void onResponseProgress(long bytesRead, long contentLength, boolean done) {
        Log.d((String)TAG, (String)("onResponseProgress======done====>>" + done));
        DownloadModel download = new DownloadModel();
        download.setTotalFileSize(contentLength);
        download.setCurrentFileSize(bytesRead);
        int progress = (int)(bytesRead * 100L / contentLength);
        download.setProgress(progress);
        this.sendNotification(download);
    }

    public static void startDownloadFileService(Context context, AppInfoModel appInfoModel) {
        Log.d((String)TAG, (String)"startDownloadFileService");
        Intent intent = new Intent(context, DownloadFileService.class);
        intent.putExtra("INTENT_DOWNLOAD_MODEL", (Serializable)appInfoModel);
        context.startService(intent);
    }

    public void onDestroy() {
        super.onDestroy();
        Log.d((String)TAG, (String)"onDestroy()");
        this.destoryVariable();
    }

    public void destoryVariable() {
        Log.d((String)TAG, (String)"destoryVariable()");
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            Log.d((String)TAG, (String)"subscription.isUnsubscribed()");
            this.subscription.unsubscribe();
        }
        if (this.rxBus != null) {
            Log.d((String)TAG, (String)"rxBus.release()");
            this.rxBus.removeObserverable("MESSAGE_PROGRESS");
        }
        if (this.notificationManager != null) {
            Log.d((String)TAG, (String)"notificationManager.cancel(0)");
            this.notificationManager.cancel(0);
        }
    }
}

