/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.sdk.liveness.model.config;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.trustdecision.sdk.liveness.model.STException;
import com.trustdecision.sdk.liveness.model.config.AbsLoadLLVM;
import com.trustdecision.sdk.liveness.model.config.IConfig;
import com.trustdecision.sdk.liveness.model.config.ModelsConfig;

public class DetectorConfig
implements IConfig {
    public static final Parcelable.Creator<DetectorConfig> CREATOR = new Parcelable.Creator<DetectorConfig>(){

        public DetectorConfig createFromParcel(Parcel parcel) {
            return new DetectorConfig(parcel);
        }

        public DetectorConfig[] newArray(int n) {
            return new DetectorConfig[n];
        }
    };
    private String licenseContent;
    private ModelsConfig modelsConfig;

    protected DetectorConfig(Builder builder) {
        this.licenseContent = builder.licenseContent;
        this.modelsConfig = builder.modelsConfig;
    }

    protected DetectorConfig(Parcel parcel) {
        this.licenseContent = parcel.readString();
        this.modelsConfig = (ModelsConfig)parcel.readParcelable(ModelsConfig.class.getClassLoader());
    }

    @Override
    public boolean check() throws STException {
        if (!TextUtils.isEmpty((CharSequence)this.licenseContent)) {
            this.modelsConfig.check();
            return true;
        }
        throw new STException(1000, "license not found");
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.licenseContent);
        parcel.writeParcelable((Parcelable)this.modelsConfig, n);
    }

    public void readFromParcel(Parcel parcel) {
        this.licenseContent = parcel.readString();
        this.modelsConfig = (ModelsConfig)parcel.readParcelable(ModelsConfig.class.getClassLoader());
    }

    public static class Builder
    extends AbsLoadLLVM {
        private String licenseContent;
        private ModelsConfig modelsConfig;

        public Builder setLicenseContent(String string2) {
            this.licenseContent = string2;
            return this;
        }

        public Builder setModelsConfig(ModelsConfig modelsConfig) {
            this.modelsConfig = modelsConfig;
            return this;
        }

        public DetectorConfig build() {
            if (this.modelsConfig == null) {
                this.modelsConfig = new ModelsConfig.Builder().build();
            }
            return new DetectorConfig(this);
        }
    }
}

