/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.liveness.cw.st.widget.finder.childs;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Base64;
import android.view.View;

public class VerifyView
extends View {
    private int PAINT_STROKE_WIDTH = 20;
    private int SPEED = 20;
    private Paint mSweepGradientPaint;
    private int mSpeed = 20;
    private RectF mCircleRect;
    SweepGradient mSweepGradient;

    public VerifyView(Context context) {
        super(context);
        this.init();
    }

    public VerifyView(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public VerifyView(Context context, @Nullable AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init();
    }

    private void init() {
        this.mCircleRect = new RectF();
        this.mSweepGradientPaint = new Paint();
        this.mSweepGradientPaint.setStyle(Paint.Style.STROKE);
        this.mSweepGradientPaint.setAntiAlias(true);
        this.mSweepGradientPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mSweepGradientPaint.setStrokeWidth((float)this.PAINT_STROKE_WIDTH);
    }

    private SweepGradient getSweepGradient() {
        if (this.mSweepGradient == null) {
            this.mSweepGradient = new SweepGradient((float)((Math.min(this.getWidth(), this.getHeight()) - this.getPaddingLeft() - this.getPaddingRight()) / 2), (float)((Math.min(this.getWidth(), this.getHeight()) - this.getPaddingTop() - this.getPaddingBottom()) / 2), new int[]{0, Color.parseColor((String)VerifyView.i1i1iI1I11iI("QVx9O1FYVw=="))}, new float[]{0.0f, 0.1f});
        }
        return this.mSweepGradient;
    }

    public void setMaskPathColor(@ColorInt int n) {
        this.mSweepGradientPaint.setColor(n);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int n = Math.min(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight() - 2 * this.PAINT_STROKE_WIDTH, this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - 2 * this.PAINT_STROKE_WIDTH);
        int n2 = (this.getWidth() - n) / 2;
        int n3 = (this.getHeight() - n) / 2;
        int n4 = n2 + n;
        int n5 = n3 + n;
        this.mCircleRect.set((float)n2, (float)n3, (float)n4, (float)n5);
        float f2 = 10.0f;
        float f3 = 100.0f;
        canvas.save();
        this.mSpeed = (this.mSpeed + this.SPEED) % 360;
        canvas.rotate((float)this.mSpeed, this.mCircleRect.centerX(), this.mCircleRect.centerY());
        this.mSweepGradientPaint.setShader((Shader)new SweepGradient(this.mCircleRect.centerX(), this.mCircleRect.centerY(), new int[]{0, Color.parseColor((String)VerifyView.i1i1iI1I11iI("QVx9O1FYVw=="))}, new float[]{f2 / 360.0f, f3 / 360.0f}));
        canvas.drawArc(this.mCircleRect, f2, f3, false, this.mSweepGradientPaint);
        this.mSweepGradientPaint.setShader((Shader)new SweepGradient(this.mCircleRect.centerX(), this.mCircleRect.centerY(), new int[]{0, Color.parseColor((String)VerifyView.linkxxxxx("122d205d565c56", 98))}, new float[]{(f2 + 180.0f) / 360.0f, (f3 + 180.0f) / 360.0f}));
        canvas.drawArc(this.mCircleRect, f2, f3 + 180.0f, false, this.mSweepGradientPaint);
        canvas.restore();
        this.getHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                VerifyView.this.invalidate();
            }
        }, (long)(20000 * this.SPEED / 3600));
    }

    private static String linkxxxxx(String string2, int n) {
        try {
            int n2;
            int n3;
            int n4 = string2.length() / 2;
            char[] cArray = string2.toCharArray();
            byte[] byArray = new byte[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = n3 * 2;
                byArray[n3] = (byte)("0123456789abcdef".indexOf(cArray[n2]) << 4 | "0123456789abcdef".indexOf(cArray[n2 + 1]));
            }
            n3 = (byte)(n ^ 0x5D);
            n2 = byArray.length;
            byArray[0] = (byte)(byArray[0] ^ 0x31);
            byte by = byArray[0];
            for (int i2 = 1; i2 < n2; ++i2) {
                byte by2 = byArray[i2];
                byArray[i2] = (byte)(byArray[i2] ^ by ^ n3);
                by = by2;
            }
            return new String(byArray, "utf-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String i1i1iI1I11iI(String string2) {
        try {
            byte[] byArray = Base64.decode((String)string2, (int)0);
            int n = byArray.length;
            byte[] byArray2 = "bmOyem".getBytes();
            int n2 = byArray2.length;
            for (int i2 = 0; i2 < n; ++i2) {
                byArray[i2] = (byte)(byArray[i2] ^ byArray2[i2 % n2]);
            }
            return new String(byArray, "utf-8");
        }
        catch (Exception exception) {
            return null;
        }
    }
}

