/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.liveness.cw.st.widget.camera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.util.Base64;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import com.trustdecision.sdk.liveness.constants.STImageOrientation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SenseCamera {
    public static final int CAMERA_FACING_BACK = 0;
    public static final int CAMERA_FACING_FRONT = 1;
    public static final Size DEFAULT_PREVIEW_SIZE = new Size(640, 480);
    private static final int DUMMY_TEXTURE_NAME = 100;
    private static final float ASPECT_RATIO_TOLERANCE = 0.01f;
    private final Object mCameraLock = new Object();
    private Context mContext;
    private Camera mCamera;
    private int mFacing = 0;
    private int mCameraId = -1;
    private int mRotation = -1;
    private Size mPreviewSize = new Size(640, 480);
    private float mRequestedFps = 24.0f;
    private int mRequestedPreviewWidth = 640;
    private int mRequestedPreviewHeight = 480;
    private SurfaceTexture mEmptySurfaceTexture;
    private ByteBuffer mByteBuffer;
    private Camera.PreviewCallback mPreviewCallback;

    private SenseCamera() {
    }

    private static int getIdForRequestedCamera(int n) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i2 = 0; i2 < Camera.getNumberOfCameras(); ++i2) {
            Camera.getCameraInfo((int)i2, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != n) continue;
            return i2;
        }
        return -1;
    }

    private static SizePair selectSizePair(Camera camera, int n, int n2) {
        Camera.Size size;
        Object object;
        Object object2;
        try {
            object2 = camera.getParameters();
            object = object2.getSupportedPreviewSizes();
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    size = (Camera.Size)iterator.next();
                    if (size.width != 640 || size.height != 480) continue;
                    return new SizePair(size, null);
                }
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    size = (Camera.Size)iterator.next();
                    if (size.width != n || size.height != n2) continue;
                    return new SizePair(size, null);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = SenseCamera.generateValidPreviewSizeList(camera);
        object = null;
        int n3 = Integer.MAX_VALUE;
        size = object2.iterator();
        while (size.hasNext()) {
            SizePair sizePair = (SizePair)size.next();
            Size size2 = sizePair.previewSize();
            int n4 = Math.abs(size2.getWidth() - n) + Math.abs(size2.getHeight() - n2);
            if (n4 >= n3) continue;
            object = sizePair;
            n3 = n4;
        }
        return object;
    }

    private static List<SizePair> generateValidPreviewSizeList(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPictureSizes();
        ArrayList<SizePair> arrayList = new ArrayList<SizePair>();
        block0: for (Camera.Size size : list) {
            float f2 = (float)size.width / (float)size.height;
            for (Camera.Size size2 : list2) {
                float f3 = (float)size2.width / (float)size2.height;
                if (!(Math.abs(f2 - f3) < 0.01f)) continue;
                arrayList.add(new SizePair(size, size2));
                continue block0;
            }
        }
        if (arrayList.isEmpty()) {
            for (Camera.Size size : list) {
                arrayList.add(new SizePair(size, null));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.mCameraLock;
        synchronized (object) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"MissingPermission"})
    public SenseCamera start(SurfaceHolder surfaceHolder) throws IOException, RuntimeException {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera != null) {
                return this;
            }
            this.mCamera = this.createCamera();
            this.mCamera.setPreviewDisplay(surfaceHolder);
            this.mCamera.startPreview();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"MissingPermission"})
    public SenseCamera start() throws IOException, RuntimeException {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera != null) {
                return this;
            }
            this.mCamera = this.createCamera();
            this.mEmptySurfaceTexture = new SurfaceTexture(36197);
            this.mCamera.setPreviewTexture(this.mEmptySurfaceTexture);
            this.mCamera.startPreview();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mByteBuffer != null) {
                this.mByteBuffer.clear();
                this.mByteBuffer = null;
            }
            if (this.mCamera != null) {
                try {
                    this.mCamera.stopPreview();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.mCamera.setPreviewCallbackWithBuffer(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.mCamera.setPreviewDisplay(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.mCamera.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mCamera = null;
            }
        }
    }

    public Size getPreviewSize() {
        return this.mPreviewSize;
    }

    public int getCameraFacing() {
        return this.mFacing;
    }

    private Camera createCamera() throws RuntimeException {
        int n;
        Camera camera;
        int n2;
        int n3 = n2 = this.mCameraId == -1 ? SenseCamera.getIdForRequestedCamera(this.mFacing) : this.mCameraId;
        if (n2 == -1) {
            throw new IllegalStateException(SenseCamera.i1i1iI1I11iI("GhU3Gj1aLBktWiQfNx5iBDwLNxMqDicSeRkjGzwII1g="));
        }
        try {
            camera = Camera.open((int)n2);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException(SenseCamera.linkxxxxx("30394e3c473d036918265b2a5a2a512c467812635d205f2c573b447a176c00681f62193d03", 103) + runtimeException.getMessage(), runtimeException);
        }
        if (camera == null) {
            throw new IllegalStateException(SenseCamera.i1i1iI1I11iI("DBQpGDYNLFY6Gy8TKxtiEysILQQ="));
        }
        SizePair sizePair = SenseCamera.selectSizePair(camera, this.mRequestedPreviewWidth, this.mRequestedPreviewHeight);
        if (sizePair == null) {
            throw new IllegalStateException(SenseCamera.i1i1iI1I11iI("GhU3Gj1aLBktWiQfNx5iBSwTNhc7FidWKQgnADAfNVYqEzgTdw=="));
        }
        Size size = sizePair.pictureSize();
        this.mPreviewSize = sizePair.previewSize();
        int[] nArray = this.selectPreviewFpsRange(camera, this.mRequestedFps);
        if (nArray == null) {
            throw new IllegalStateException(SenseCamera.i1i1iI1I11iI("GhU3Gj1aLBktWiQfNx5iBSwTNhc7FidWKQgnADAfNVY/CCMbPAliBjwIYgU8GS0YPVowFzcdJ1g="));
        }
        Camera.Parameters parameters = camera.getParameters();
        if (size != null) {
            parameters.setPictureSize(size.getWidth(), size.getHeight());
        }
        parameters.setPreviewSize(this.mPreviewSize.getWidth(), this.mPreviewSize.getHeight());
        parameters.setPreviewFpsRange(nArray[0], nArray[1]);
        parameters.setPreviewFormat(17);
        if (this.mRotation != -1) {
            n = this.mRotation * 90;
            camera.setDisplayOrientation(n);
            parameters.setRotation(n);
        } else {
            this.setRotation(camera, parameters, n2);
        }
        if (parameters.getSupportedFocusModes().contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        camera.setParameters(parameters);
        camera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(byte[] byArray, Camera camera) {
                if (SenseCamera.this.mPreviewCallback != null && SenseCamera.this.mByteBuffer != null) {
                    SenseCamera.this.mPreviewCallback.onPreviewFrame(SenseCamera.this.mByteBuffer.array(), camera);
                }
                if (SenseCamera.this.mByteBuffer != null) {
                    camera.addCallbackBuffer(SenseCamera.this.mByteBuffer.array());
                }
            }
        });
        n = ImageFormat.getBitsPerPixel((int)17);
        long l2 = this.mPreviewSize.getHeight() * this.mPreviewSize.getWidth() * n;
        int n4 = (int)Math.ceil((double)l2 / 8.0) + 1;
        byte[] byArray = new byte[n4];
        this.mByteBuffer = ByteBuffer.wrap(byArray);
        if (!this.mByteBuffer.hasArray() || this.mByteBuffer.array() != byArray) {
            throw new IllegalStateException(SenseCamera.linkxxxxx("30374e324733036718285b394c3d592c1c7a0b770e7a4a385d2b5d284a7a0c73112152235e2b493806", 105));
        }
        camera.addCallbackBuffer(this.mByteBuffer.array());
        return camera;
    }

    public void setOnPreviewFrameCallback(Camera.PreviewCallback previewCallback) {
        this.mPreviewCallback = previewCallback;
    }

    private int[] selectPreviewFpsRange(Camera camera, float f2) {
        int n = (int)(f2 * 1000.0f);
        int[] nArray = null;
        int n2 = Integer.MAX_VALUE;
        List list = camera.getParameters().getSupportedPreviewFpsRange();
        for (int[] nArray2 : list) {
            int n3 = n - nArray2[0];
            int n4 = n - nArray2[1];
            int n5 = Math.abs(n3) + Math.abs(n4);
            if (n5 >= n2) continue;
            nArray = nArray2;
            n2 = n5;
        }
        return nArray;
    }

    private void setRotation(Camera camera, Camera.Parameters parameters, int n) {
        int n2;
        int n3;
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        int n4 = 0;
        int n5 = windowManager != null ? windowManager.getDefaultDisplay().getRotation() : 0;
        switch (n5) {
            case 0: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 90;
                break;
            }
            case 2: {
                n4 = 180;
                break;
            }
            case 3: {
                n4 = 270;
                break;
            }
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
        if (cameraInfo.facing == 1) {
            n3 = (cameraInfo.orientation + n4) % 360;
            n2 = (360 - n3) % 360;
        } else {
            n2 = n3 = (cameraInfo.orientation - n4 + 360) % 360;
        }
        this.mRotation = n3 / 90;
        camera.setDisplayOrientation(n2);
        parameters.setRotation(n3);
    }

    public Bitmap getDrawingCache() {
        if (this.mByteBuffer == null) {
            return null;
        }
        return SenseCamera.nv21ToBitmap(this.mByteBuffer.array(), DEFAULT_PREVIEW_SIZE.getWidth(), DEFAULT_PREVIEW_SIZE.getHeight(), this.mRotation);
    }

    public static Bitmap nv21ToBitmap(byte[] byArray, int n, int n2, @STImageOrientation int n3) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            Bitmap bitmap;
            YuvImage yuvImage = new YuvImage(byArray, 17, n, n2, null);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Rect rect = new Rect(0, 0, yuvImage.getWidth(), yuvImage.getHeight());
            yuvImage.compressToJpeg(rect, 100, (OutputStream)byteArrayOutputStream);
            Bitmap bitmap2 = BitmapFactory.decodeByteArray((byte[])byteArrayOutputStream.toByteArray(), (int)0, (int)byteArrayOutputStream.toByteArray().length);
            if (bitmap2 == null) {
                return null;
            }
            if (n3 != 0) {
                Matrix matrix = new Matrix();
                matrix.postRotate((float)(n3 * 90));
                matrix.postScale(-1.0f, 1.0f);
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)bitmap2.getWidth(), (int)bitmap2.getHeight(), (Matrix)matrix, (boolean)true);
            } else {
                bitmap = bitmap2;
            }
            return bitmap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public int getRotationDegrees() {
        return this.mRotation * 90;
    }

    private static String linkxxxxx(String string2, int n) {
        try {
            int n2;
            int n3;
            int n4 = string2.length() / 2;
            char[] cArray = string2.toCharArray();
            byte[] byArray = new byte[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = n3 * 2;
                byArray[n3] = (byte)("0123456789abcdef".indexOf(cArray[n2]) << 4 | "0123456789abcdef".indexOf(cArray[n2 + 1]));
            }
            n3 = (byte)(n ^ 0x79);
            n2 = byArray.length;
            byArray[0] = (byte)(byArray[0] ^ 0x76);
            byte by = byArray[0];
            for (int i2 = 1; i2 < n2; ++i2) {
                byte by2 = byArray[i2];
                byArray[i2] = (byte)(byArray[i2] ^ by ^ n3);
                by = by2;
            }
            return new String(byArray, "utf-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String i1i1iI1I11iI(String string2) {
        try {
            byte[] byArray = Base64.decode((String)string2, (int)0);
            int n = byArray.length;
            byte[] byArray2 = "YzBv".getBytes();
            int n2 = byArray2.length;
            for (int i2 = 0; i2 < n; ++i2) {
                byArray[i2] = (byte)(byArray[i2] ^ byArray2[i2 % n2]);
            }
            return new String(byArray, "utf-8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class Size {
        private int mWidth;
        private int mHeight;

        public Size(int n, int n2) {
            this.mWidth = n;
            this.mHeight = n2;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public String toString() {
            return SenseCamera.i1i1iI1I11iI("ChM4EwItKxItEnhW") + this.mWidth + SenseCamera.linkxxxxx("5a2b440648084714090e", 94) + this.mHeight + SenseCamera.linkxxxxx("2b", 87);
        }
    }

    private static class SizePair {
        private Size mPreview;
        private Size mPicture;

        public SizePair(Camera.Size size, Camera.Size size2) {
            this.mPreview = new Size(size.width, size.height);
            if (size2 != null) {
                this.mPicture = new Size(size2.width, size2.height);
            }
        }

        public Size previewSize() {
            return this.mPreview;
        }

        public Size pictureSize() {
            return this.mPicture;
        }
    }

    public static class Builder {
        private final SenseCamera mSenseCamera = new SenseCamera();

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException(SenseCamera.i1i1iI1I11iI("FxViFTYUNhMhDmIFLAoyGjAfJlg="));
            }
            this.mSenseCamera.mContext = context;
        }

        public Builder setRequestedFps(float f2) {
            if (f2 <= 0.0f) {
                throw new IllegalArgumentException(SenseCamera.i1i1iI1I11iI("EBQ0FzUTJlY/CjFMeQ==") + f2);
            }
            this.mSenseCamera.mRequestedFps = f2;
            return this;
        }

        public Builder setRequestedPreviewSize(int n, int n2) {
            int n3 = 1000000;
            if (n <= 0 || n > 1000000 || n2 <= 0 || n2 > 1000000) {
                throw new IllegalArgumentException(SenseCamera.i1i1iI1I11iI("EBQ0FzUTJlYpCCcAMB81VioTOBNjWg==") + n + SenseCamera.i1i1iI1I11iI("IQ==") + n2);
            }
            this.mSenseCamera.mRequestedPreviewWidth = n;
            this.mSenseCamera.mRequestedPreviewHeight = n2;
            return this;
        }

        public Builder setFacing(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(SenseCamera.i1i1iI1I11iI("EBQ0FzUTJlY6Gy8TKxt4Vg==") + n);
            }
            this.mSenseCamera.mFacing = n;
            return this;
        }

        public Builder setCameraId(int n) {
            this.mSenseCamera.mCameraId = n;
            return this;
        }

        public Builder setRotation(int n) {
            this.mSenseCamera.mRotation = (n + 360) % 360 / 90;
            return this;
        }

        public SenseCamera build() {
            return this.mSenseCamera;
        }
    }
}

