/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.sdk.liveness.model.config;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.trustdecision.sdk.liveness.model.STException;
import com.trustdecision.sdk.liveness.model.config.AbsLoadLLVM;
import com.trustdecision.sdk.liveness.model.config.IConfig;
import com.trustdecision.sdk.liveness.model.config.ModelsConfig;

public class DetectorConfig
implements IConfig {
    public static final Parcelable.Creator<DetectorConfig> CREATOR;
    private String licenseContent;
    private ModelsConfig modelsConfig;

    protected DetectorConfig(Builder builder) {
        this.licenseContent = builder.licenseContent;
        this.modelsConfig = builder.modelsConfig;
    }

    protected DetectorConfig(Parcel parcel) {
        this.licenseContent = parcel.readString();
        this.modelsConfig = (ModelsConfig)parcel.readParcelable(ModelsConfig.class.getClassLoader());
    }

    static {
        System.loadLibrary("llvmliveness");
        CREATOR = new Parcelable.Creator<DetectorConfig>(){

            public DetectorConfig createFromParcel(Parcel parcel) {
                return new DetectorConfig(parcel);
            }

            public DetectorConfig[] newArray(int n) {
                return new DetectorConfig[n];
            }
        };
    }

    @Override
    public boolean check() throws STException {
        if (!TextUtils.isEmpty((CharSequence)this.licenseContent)) {
            this.modelsConfig.check();
            return true;
        }
        throw new STException(1000, "license not found");
    }

    public native int describeContents();

    public native void writeToParcel(Parcel var1, int var2);

    public native void readFromParcel(Parcel var1);

    public static class Builder
    extends AbsLoadLLVM {
        private String licenseContent;
        private ModelsConfig modelsConfig;

        public native Builder setLicenseContent(String var1);

        public native Builder setModelsConfig(ModelsConfig var1);

        public native DetectorConfig build();

        static {
            System.loadLibrary("llvmliveness");
        }
    }
}

