/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.liveness.cw.libproject.camera.gl;

import android.content.res.Resources;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Log;
import java.io.InputStream;

public class Gl2Utils {
    public static final String TAG = "GLUtils";
    public static boolean DEBUG = true;
    public static final int TYPE_FITXY = 0;
    public static final int TYPE_CENTERCROP = 1;
    public static final int TYPE_CENTERINSIDE = 2;
    public static final int TYPE_FITSTART = 3;
    public static final int TYPE_FITEND = 4;

    private Gl2Utils() {
    }

    public static void getShowMatrix(float[] fArray, int n, int n2, int n3, int n4) {
        if (n2 > 0 && n > 0 && n3 > 0 && n4 > 0) {
            float f2;
            float f3 = (float)n3 / (float)n4;
            float f4 = (float)n / (float)n2;
            float[] fArray2 = new float[16];
            float[] fArray3 = new float[16];
            if (f2 > f3) {
                float f5 = f3;
                f3 = -f3 / f4;
                f4 = f5 / f4;
                Matrix.orthoM((float[])fArray2, (int)0, (float)f3, (float)f4, (float)-1.0f, (float)1.0f, (float)1.0f, (float)3.0f);
            } else {
                float f6 = f3;
                f3 = -f4 / f3;
                Matrix.orthoM((float[])fArray2, (int)0, (float)-1.0f, (float)1.0f, (float)f3, (float)(f4 /= f6), (float)1.0f, (float)3.0f);
            }
            Matrix.setLookAtM((float[])fArray3, (int)0, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray3, (int)0);
        }
    }

    public static void getMatrix(float[] fArray, int n, int n2, int n3, int n4, int n5) {
        if (n3 > 0 && n2 > 0 && n4 > 0 && n5 > 0) {
            float f2;
            float[] fArray2 = new float[16];
            float[] fArray3 = new float[16];
            if (n == 0) {
                Matrix.orthoM((float[])fArray2, (int)0, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f, (float)1.0f, (float)3.0f);
                Matrix.setLookAtM((float[])fArray3, (int)0, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray3, (int)0);
            }
            float f3 = (float)n4 / (float)n5;
            float f4 = (float)n2 / (float)n3;
            if (f2 > f3) {
                switch (n) {
                    default: {
                        break;
                    }
                    case 4: {
                        float f5 = f4 * 2.0f / f3 - 1.0f;
                        Matrix.orthoM((float[])fArray2, (int)0, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)f5, (float)1.0f, (float)3.0f);
                        break;
                    }
                    case 3: {
                        float f6 = 1.0f - f4 * 2.0f / f3;
                        Matrix.orthoM((float[])fArray2, (int)0, (float)-1.0f, (float)1.0f, (float)f6, (float)1.0f, (float)1.0f, (float)3.0f);
                        break;
                    }
                    case 2: {
                        float f7 = -f4 / f3;
                        f3 = f4 / f3;
                        Matrix.orthoM((float[])fArray2, (int)0, (float)-1.0f, (float)1.0f, (float)f7, (float)f3, (float)1.0f, (float)3.0f);
                        break;
                    }
                    case 1: {
                        float f8 = -f3 / f4;
                        Matrix.orthoM((float[])fArray2, (int)0, (float)f8, (float)(f3 /= f4), (float)-1.0f, (float)1.0f, (float)1.0f, (float)3.0f);
                        break;
                    }
                }
            } else {
                switch (n) {
                    default: {
                        break;
                    }
                    case 4: {
                        Matrix.orthoM((float[])fArray2, (int)0, (float)(1.0f - f3 * 2.0f / f4), (float)1.0f, (float)-1.0f, (float)1.0f, (float)1.0f, (float)3.0f);
                        break;
                    }
                    case 3: {
                        float f9 = f3 * 2.0f / f4 - 1.0f;
                        Matrix.orthoM((float[])fArray2, (int)0, (float)-1.0f, (float)f9, (float)-1.0f, (float)1.0f, (float)1.0f, (float)3.0f);
                        break;
                    }
                    case 2: {
                        float f10 = -f3 / f4;
                        Matrix.orthoM((float[])fArray2, (int)0, (float)f10, (float)(f3 /= f4), (float)-1.0f, (float)1.0f, (float)1.0f, (float)3.0f);
                        break;
                    }
                    case 1: {
                        float f11 = -f4 / f3;
                        f3 = f4 / f3;
                        Matrix.orthoM((float[])fArray2, (int)0, (float)-1.0f, (float)1.0f, (float)f11, (float)f3, (float)1.0f, (float)3.0f);
                    }
                }
            }
            Matrix.setLookAtM((float[])fArray3, (int)0, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray3, (int)0);
        }
    }

    public static void getCenterInsideMatrix(float[] fArray, int n, int n2, int n3, int n4) {
        if (n2 > 0 && n > 0 && n3 > 0 && n4 > 0) {
            float f2;
            float f3 = (float)n3 / (float)n4;
            float f4 = (float)n / (float)n2;
            float[] fArray2 = new float[16];
            float[] fArray3 = new float[16];
            if (f2 > f3) {
                float f5 = f3;
                f3 = -f4 / f3;
                Matrix.orthoM((float[])fArray2, (int)0, (float)-1.0f, (float)1.0f, (float)f3, (float)(f4 /= f5), (float)1.0f, (float)3.0f);
            } else {
                float f6 = f3;
                f3 = -f3 / f4;
                f4 = f6 / f4;
                Matrix.orthoM((float[])fArray2, (int)0, (float)f3, (float)f4, (float)-1.0f, (float)1.0f, (float)1.0f, (float)3.0f);
            }
            Matrix.setLookAtM((float[])fArray3, (int)0, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray3, (int)0);
        }
    }

    public static float[] rotate(float[] fArray, float f2) {
        Matrix.rotateM((float[])fArray, (int)0, (float)f2, (float)0.0f, (float)0.0f, (float)1.0f);
        return fArray;
    }

    public static float[] flip(float[] fArray, boolean bl, boolean bl2) {
        if (bl || bl2) {
            boolean bl3 = bl;
            bl = false;
            float f2 = bl3 ? -1.0f : 1.0f;
            float f3 = bl2 ? -1.0f : 1.0f;
            Matrix.scaleM((float[])fArray, (int)(bl ? 1 : 0), (float)f2, (float)f3, (float)1.0f);
        }
        return fArray;
    }

    public static float[] getOriginalMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static String uRes(Resources object, String object2) {
        byte[] byArray;
        StringBuilder stringBuilder;
        Resources resources = object;
        object = stringBuilder;
        stringBuilder = new StringBuilder();
        object2 = resources.getAssets().open((String)object2);
        try {
            byArray = new byte[1024];
        }
        catch (Exception exception) {
            return null;
        }
        while (true) {
            int n = ((InputStream)object2).read(byArray);
            if (-1 == n) break;
            ((StringBuilder)object).append(new String(byArray, 0, n));
        }
        return ((StringBuilder)object).toString().replaceAll("\\r\\n", "\n");
    }

    public static int createGlProgramByRes(Resources resources, String string2, String string3) {
        return Gl2Utils.createGlProgram(Gl2Utils.uRes(resources, string2), Gl2Utils.uRes(resources, string3));
    }

    public static int createGlProgram(String string2, String string3) {
        int n = Gl2Utils.loadShader(35633, string2);
        if (n == 0) {
            return 0;
        }
        int n2 = Gl2Utils.loadShader(35632, string3);
        if (n2 == 0) {
            return 0;
        }
        int n3 = GLES20.glCreateProgram();
        if (n3 != 0) {
            int n4 = n3;
            GLES20.glAttachShader((int)n3, (int)n);
            GLES20.glAttachShader((int)n4, (int)n2);
            GLES20.glLinkProgram((int)n4);
            int[] nArray = new int[1];
            GLES20.glGetProgramiv((int)n3, (int)35714, (int[])nArray, (int)0);
            if (nArray[0] != 1) {
                Gl2Utils.glError(1, "Could not link program:" + GLES20.glGetProgramInfoLog((int)n3));
                GLES20.glDeleteProgram((int)n3);
                n3 = 0;
            }
        }
        return n3;
    }

    public static int loadShader(int n, String object) {
        int n2 = GLES20.glCreateShader((int)n);
        if (n2 != 0) {
            int n3 = n2;
            GLES20.glShaderSource((int)n3, (String)object);
            GLES20.glCompileShader((int)n3);
            int[] nArray = new int[1];
            object = nArray;
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])object, (int)0);
            if (nArray[0] == 0) {
                Gl2Utils.glError(1, "Could not compile shader:" + n);
                Gl2Utils.glError(1, "GLES20 Error:" + GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                n2 = 0;
            }
        }
        return n2;
    }

    public static void glError(int n, Object object) {
        if (DEBUG && n != 0) {
            Log.e((String)TAG, (String)("glError:" + n + "---" + object));
        }
    }
}

