/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.liveness.cw.api.ui;

import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.drawable.AnimationDrawable;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Base64;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextSwitcher;
import android.widget.TextView;
import android.widget.ViewSwitcher;
import com.trustdecision.liveness.cw.R;
import com.trustdecision.liveness.cw.api.ui.TDLiveUiConfig;
import com.trustdecision.liveness.cw.libproject.Builder;
import com.trustdecision.liveness.cw.libproject.LiveResultActivity;
import com.trustdecision.liveness.cw.libproject.VersionUtil;
import com.trustdecision.liveness.cw.libproject.camera.CwCameraView;
import com.trustdecision.liveness.cw.libproject.camera.Size;
import com.trustdecision.liveness.cw.libproject.dialog.LiveTimeOutDialog;
import com.trustdecision.liveness.cw.libproject.dialog.OnDialogClickListener;
import com.trustdecision.liveness.cw.libproject.entity.ColorInfo;
import com.trustdecision.liveness.cw.libproject.entity.ErrorInfo;
import com.trustdecision.liveness.cw.libproject.live.CwBaseLiveFragment;
import com.trustdecision.liveness.cw.libproject.view.RoundMaskView;
import com.trustdecision.liveness.cw.util.LoggerUtil;
import com.trustdecision.liveness.cw.util.NoDoubleClickListener;
import com.trustdecision.liveness.cw.util.VoiceUtil;
import java.util.Locale;

public class TDLiveFragment
extends CwBaseLiveFragment {
    private static final int UODATE_TIPS_PERIOD = 500;
    private static final int MESSAGE_UPDATE_TIPS_TEXT = 3001;
    private static final int MESSAGE_SHOW_TIPS_DIALOG = 3002;
    private static final int MESSAGE_UPDATE_VIEW_DETECT_END = 3004;
    private static final int MESSAGE_MASK_GONE = 3005;
    private TextView timeoutTextView;
    private ImageView tipsImageView;
    private TextSwitcher tipsTextSwitcher;
    private ImageView mIvMask;
    private RoundMaskView roundMaskView;
    private int maxProjress;
    private boolean isPlayedAgainVoice;
    private AnimationDrawable actionAnimation;
    private LiveTimeOutDialog liveTimeOutDialog;
    private TextView liveDialogTitle;
    private TextView liveDialogContent;
    private TextView liveDialogExit;
    private TextView liveDialogRestart;
    private int mColorIndex = 0;
    private boolean showPrepareViewAnim = true;
    private TDLiveUiConfig cwLiveUiConfig;
    private volatile int actionGroupCount;
    private LocalBroadcastManager localBroadcastManager;
    private LiveAntiBroadcastReceiver liveAntiBroadcastReceiver;
    private NoDoubleClickListener switchCameraListener = new NoDoubleClickListener(){

        @Override
        public void onNoDoubleClick(View view) {
            if (TDLiveFragment.this.mConfig.getFacing() == 0) {
                TDLiveFragment.this.mConfig.facing(1);
                TDLiveFragment.this.cwCameraView.setFacing(1);
            } else {
                TDLiveFragment.this.mConfig.facing(0);
                TDLiveFragment.this.cwCameraView.setFacing(0);
            }
            TDLiveFragment.this.tryAgain();
        }
    };

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.localBroadcastManager = LocalBroadcastManager.getInstance((Context)context);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("action.broadcast.live.anti");
        this.liveAntiBroadcastReceiver = new LiveAntiBroadcastReceiver();
        this.localBroadcastManager.registerReceiver((BroadcastReceiver)this.liveAntiBroadcastReceiver, intentFilter);
    }

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.updateSpoofLevel(1.0f);
        this.rootView = layoutInflater.inflate(R.layout.td_fragment_live, viewGroup, false);
        this.initView(this.rootView);
        super.onCreateView(layoutInflater, viewGroup, bundle);
        return this.rootView;
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if (this.actionAnimation != null && this.actionAnimation.isRunning()) {
            this.actionAnimation.stop();
        }
        if (this.liveTimeOutDialog != null && this.liveTimeOutDialog.isShowing()) {
            this.liveTimeOutDialog.dismiss();
        }
    }

    @Override
    public ColorInfo getDefaultColor() {
        return new ColorInfo(Color.parseColor((String)TDLiveFragment.i1i1iI1I11iI("YiMcMTQDCg==")), new int[]{0, 0, 0}, R.drawable.td_live_round_mask_white);
    }

    @Override
    protected void setBgcColor(int n) {
        super.setBgcColor(n);
        this.roundMaskView.setRoundColor(((ColorInfo)this.colorInfos.get(n)).getDefaultColor());
        this.cwCameraView.setLowAndroidVersionMask(((ColorInfo)this.colorInfos.get(n)).getLowVersionColor(), ((ColorInfo)this.colorInfos.get(n)).getDefaultColor());
    }

    private void initView(View view) {
        this.actionGroupCount = this.mConfig.getActionGroupCount();
        this.cwLiveUiConfig = (TDLiveUiConfig)this.mConfig.getCwBaseUiConfig();
        if (null != this.cwLiveUiConfig) {
            view.setBackgroundColor(this.cwLiveUiConfig.getLiveBackgroundColor());
        }
        View view2 = view.findViewById(R.id.td_live_action_bar);
        this.cwCameraView = (CwCameraView)view.findViewById(R.id.td_live_preview_view);
        this.roundMaskView = (RoundMaskView)view.findViewById(R.id.td_live_mask_view);
        this.roundMaskView.setTextVerticalRatio(0.55f);
        this.timeoutTextView = (TextView)view.findViewById(R.id.td_live_time_out);
        this.tipsImageView = (ImageView)view.findViewById(R.id.td_live_tips_imageview);
        this.tipsTextSwitcher = (TextSwitcher)view.findViewById(R.id.td_live_tips_textswitcher);
        this.mIvMask = (ImageView)view.findViewById(R.id.iv_mask);
        int n = R.drawable.td_live_mask_face;
        if (this.mConfig.getMaskImageResourceId() > 0) {
            n = this.mConfig.getMaskImageResourceId();
        }
        this.mIvMask.setImageResource(n);
        int n2 = this.getResources().getColor(R.color.td_black);
        ((ImageView)view.findViewById(R.id.td_live_camera_switch)).setColorFilter(n2, PorterDuff.Mode.SRC_ATOP);
        if (this.cwLiveUiConfig.showActionbar) {
            view.findViewById(R.id.td_live_back).setVisibility(4);
            view2.setVisibility(0);
        } else {
            view.findViewById(R.id.td_live_back).setVisibility(0);
            view2.setVisibility(4);
        }
        if (Camera.getNumberOfCameras() >= 2 && this.mConfig.isShowSwitchCamera()) {
            view.findViewById(R.id.td_live_camera_switch).setVisibility(0);
            view.findViewById(R.id.td_live_camera_switch).setOnClickListener((View.OnClickListener)this.switchCameraListener);
        } else {
            view.findViewById(R.id.td_live_camera_switch).setVisibility(4);
        }
        this.tipsTextSwitcher.setFactory(new ViewSwitcher.ViewFactory(){

            public View makeView() {
                TextView textView = new TextView(TDLiveFragment.this.getContext());
                textView.setTextSize(2, (float)TDLiveFragment.this.cwLiveUiConfig.getActionTipsTextSize());
                textView.setTextColor(TDLiveFragment.this.cwLiveUiConfig.getActionTipsTextColor());
                textView.setGravity(17);
                textView.setSingleLine(false);
                textView.setPadding(50, 0, 50, 0);
                textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                return textView;
            }
        });
        this.liveTimeOutDialog = new LiveTimeOutDialog(this.getContext(), R.layout.td_dialog_live_time_out);
        this.liveDialogTitle = (TextView)this.liveTimeOutDialog.getRootView().findViewById(R.id.td_live_dialog_title);
        this.liveDialogContent = (TextView)this.liveTimeOutDialog.getRootView().findViewById(R.id.td_live_dialog_content);
        this.liveDialogExit = (TextView)this.liveDialogContent.getRootView().findViewById(R.id.td_live_cancel);
        this.liveDialogRestart = (TextView)this.liveDialogContent.getRootView().findViewById(R.id.td_live_restart);
        int n3 = Builder.getCwLiveConfig().getCwBaseUiConfig().getBtnBackColor();
        if (-1 != n3) {
            this.liveDialogRestart.setBackgroundColor(n3);
        }
        this.roundMaskView.setRoundColor(this.cwLiveUiConfig.getLiveBackgroundColor());
        NoDoubleClickListener noDoubleClickListener = new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View view) {
                TDLiveFragment.this.onBackPressed();
            }
        };
        view.findViewById(R.id.td_live_back).setOnClickListener((View.OnClickListener)noDoubleClickListener);
        view2.findViewById(R.id.td_action_bar_left_image).setOnClickListener((View.OnClickListener)noDoubleClickListener);
        final ImageView imageView = (ImageView)view2.findViewById(R.id.td_action_bar_right_image);
        if (this.mConfig.isPlaySound()) {
            imageView.setImageResource(R.drawable.td_live_voice_open);
        } else {
            imageView.setImageResource(R.drawable.td_live_voice_close);
        }
        imageView.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View view) {
                TDLiveFragment.this.mConfig.playSound(!TDLiveFragment.this.mConfig.isPlaySound());
                if (TDLiveFragment.this.mConfig.isPlaySound()) {
                    imageView.setImageResource(R.drawable.td_live_voice_open);
                } else {
                    imageView.setImageResource(R.drawable.td_live_voice_close);
                    VoiceUtil.stopVoice();
                }
            }
        });
        int n4 = this.mConfig.getFacing();
        if (n4 == 0) {
            this.cwCameraView.setFacing(n4);
        }
        if (VersionUtil.isShanDongVersion()) {
            this.resetViewColor(view2, view);
        }
    }

    private void resetViewColor(View view, View view2) {
        int n = this.getResources().getColor(R.color.td_black);
        ((ImageView)view.findViewById(R.id.td_action_bar_left_image)).setColorFilter(n, PorterDuff.Mode.SRC_ATOP);
        ((ImageView)view.findViewById(R.id.td_action_bar_right_image)).setColorFilter(n, PorterDuff.Mode.SRC_ATOP);
        ((TextView)view.findViewById(R.id.td_action_bar_title)).setTextColor(n);
        ((ImageView)view2.findViewById(R.id.td_live_back)).setColorFilter(n, PorterDuff.Mode.SRC_ATOP);
        ((ImageView)view2.findViewById(R.id.td_live_camera_switch)).setColorFilter(n, PorterDuff.Mode.SRC_ATOP);
    }

    @Override
    protected void startPreviewAnim() {
        super.startPreviewAnim();
        if (this.showPrepareViewAnim) {
            this.showPrepareViewAnim = false;
            this.roundMaskView.startAnim(0);
        }
    }

    @Override
    protected void adjustPreviewView(Size size, Point point, int n) {
        super.adjustPreviewView(size, point, n);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.cwCameraView.getLayoutParams();
        if (n == 2) {
            point.y = this.mConfig.getPageWidth() == 0 ? (int)((double)point.y / 1.5) : this.mConfig.getPageWidth();
            int n2 = Math.min(point.x, point.y) * 7 / 10;
            layoutParams.width = (int)((double)n2 * 1.0 * (double)size.getWidth() / (double)size.getHeight());
            layoutParams.height = n2;
        } else {
            int n3;
            if (this.mConfig.getPageWidth() == 0) {
                if ((double)point.x * 1.0 / (double)point.y > 0.8) {
                    point.x /= 2;
                } else if ((double)point.x * 1.0 / (double)point.y > 0.6) {
                    point.x = (int)((double)point.x / 1.1);
                }
            } else {
                point.x = this.mConfig.getPageWidth();
            }
            layoutParams.width = n3 = Math.min(point.x, point.y) * 7 / 10;
            layoutParams.height = (int)((double)n3 * 1.0 * (double)size.getWidth() / (double)size.getHeight());
        }
        this.cwCameraView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.roundMaskView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.cwCameraView.roundPreview(R.drawable.td_live_round_mask, R.color.td_black, null);
        this.mIvMask.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    protected void setMaxProgress(int n) {
        super.setMaxProgress(n);
        this.maxProjress = n;
    }

    @Override
    protected void updateProgressBar(int n) {
        super.updateProgressBar(n);
        boolean bl = true;
        if (n <= this.maxProjress / 2) {
            this.timeoutTextView.setTextColor(this.cwLiveUiConfig.getTimeoutTextBigColor());
            this.timeoutTextView.setTextSize(2, (float)this.cwLiveUiConfig.getTimeoutBigTextSize());
            bl = false;
        } else {
            this.timeoutTextView.setTextColor(this.cwLiveUiConfig.getTimeoutTextNormalColor());
            this.timeoutTextView.setTextSize(2, (float)this.cwLiveUiConfig.getTimeoutNormalTextSize());
        }
        String string2 = TDLiveFragment.linkxxxxx("221112", 99);
        this.timeoutTextView.setText((CharSequence)String.format(Locale.CHINA, string2, n));
        int n2 = this.getCurrentAction();
        if (n2 == 1 || n2 == 512 || bl || this.isPlayedAgainVoice || !this.mConfig.isPlaySound()) {
            return;
        }
        this.isPlayedAgainVoice = true;
        if (n2 == 16) {
            VoiceUtil.playVoice(this.getContext(), R.raw.td_open_widely);
        } else if (n2 != 256) {
            VoiceUtil.playVoice(this.getContext(), R.raw.td_again);
        }
    }

    @Override
    protected void dismissProgress(int n) {
        super.dismissProgress(n);
        this.timeoutTextView.setVisibility(n);
    }

    @Override
    protected boolean dispatchFail(int n, int n2) {
        if (this.mConfig.getActionGroupCount() == 1) {
            if (n != 703 || this.mConfig.isShowTimeoutDialog()) {
                // empty if block
            }
            if (!this.mConfig.isErrorDialog() || this.mConfig.getInterceptErrorCode().contains(n)) {
                // empty if block
            }
            return true;
        }
        this.isInterruptedLive = false;
        if (n != 705) {
            this.restartActionDetect();
        }
        --this.actionGroupCount;
        return this.actionGroupCount == 0;
    }

    @Override
    protected void updateStepView(int n) {
        super.updateStepView(n);
        if (this.getContext() == null) {
            return;
        }
        this.isPlayedAgainVoice = false;
        if (!this.mConfig.isShowArrow()) {
            this.roundMaskView.setTipsMessage("");
        }
        switch (n) {
            case 1: {
                this.tipsImageView.setImageResource(R.drawable.td_live_head_default);
                this.tipsTextSwitcher.setText((CharSequence)this.getString(R.string.td_live_action_ready));
                if (!this.mConfig.isShowArrow()) break;
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_not_center));
                break;
            }
            case 512: {
                if (this.mConfig.isShowArrow()) {
                    this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_not_center));
                }
                this.tipsTextSwitcher.setCurrentText((CharSequence)this.getString(R.string.td_live_action_ready));
                this.tipsImageView.setImageResource(R.drawable.td_live_head_default);
                this.startFlashLive();
                break;
            }
            case 8: {
                this.tipsTextSwitcher.setText((CharSequence)this.getString(R.string.td_live_action_blink_eye));
                this.tipsImageView.setVisibility(0);
                this.tipsImageView.setImageResource(R.drawable.td_live_eye_anim);
                if (this.mConfig.isShowArrow()) {
                    this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_action_blink_eye));
                    break;
                }
                this.roundMaskView.setTipsMessage("");
                break;
            }
            case 2: {
                this.tipsTextSwitcher.setText((CharSequence)this.getString(R.string.td_live_action_head_left));
                this.tipsImageView.setVisibility(0);
                this.tipsImageView.setImageResource(R.drawable.td_live_head_left_anim);
                if (this.mConfig.isShowArrow()) {
                    this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_action_head_left), true, false);
                    break;
                }
                this.roundMaskView.setTipsMessage("");
                break;
            }
            case 4: {
                this.tipsTextSwitcher.setText((CharSequence)this.getString(R.string.td_live_action_head_right));
                this.tipsImageView.setVisibility(0);
                this.tipsImageView.setImageResource(R.drawable.td_live_head_right_anim);
                if (this.mConfig.isShowArrow()) {
                    this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_action_head_right), false, true);
                    break;
                }
                this.roundMaskView.setTipsMessage("");
                break;
            }
            case 16: {
                if (this.mConfig.isShowArrow()) {
                    this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_action_open_mouth));
                } else {
                    this.roundMaskView.setTipsMessage("");
                }
                this.tipsTextSwitcher.setText((CharSequence)this.getString(R.string.td_live_action_open_mouth));
                this.tipsImageView.setVisibility(0);
                this.tipsImageView.setImageResource(R.drawable.td_live_mouth_anim);
                break;
            }
            case 256: {
                this.tipsTextSwitcher.setText((CharSequence)this.getString(R.string.td_live_action_head_shake));
                this.tipsImageView.setVisibility(0);
                this.tipsImageView.setImageResource(R.drawable.td_live_head_shake_anim);
                if (this.mConfig.isShowArrow()) {
                    this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_action_head_shake), false, false);
                    break;
                }
                this.roundMaskView.setTipsMessage("");
                break;
            }
            case 32: {
                if (this.mConfig.isShowArrow()) {
                    this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_action_head_up_down));
                } else {
                    this.roundMaskView.setTipsMessage("");
                }
                this.tipsTextSwitcher.setText((CharSequence)this.getString(R.string.td_live_action_head_up_down));
                this.tipsImageView.setVisibility(0);
                this.tipsImageView.setImageResource(R.drawable.td_live_head_up_down_anim);
                break;
            }
            case 1024: {
                if (this.mConfig.isShowArrow()) {
                    this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_action_phone_forward_backward));
                } else {
                    this.roundMaskView.setTipsMessage("");
                }
                this.tipsTextSwitcher.setText((CharSequence)this.getString(R.string.td_live_action_phone_forward_backward));
                this.tipsImageView.setVisibility(0);
                this.tipsImageView.setImageResource(R.drawable.td_live_head_forward_backward_anim);
            }
        }
        try {
            if (this.actionAnimation != null && this.actionAnimation.isRunning()) {
                this.actionAnimation.stop();
            }
            this.actionAnimation = (AnimationDrawable)this.tipsImageView.getDrawable();
            this.actionAnimation.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void startGreenCircle() {
        this.roundMaskView.startAnim(1);
    }

    @Override
    protected void updateTipsView(int n, int n2) {
        super.updateTipsView(n, n2);
        switch (n) {
            case 0: {
                if (!this.mConfig.isShowArrow()) {
                    this.roundMaskView.setTipsMessage("");
                    break;
                }
                if (this.getCurrentAction() == 1) break;
                this.setTipsMessage();
                break;
            }
            case 1: {
                this.roundMaskView.setTipsMessage("");
                break;
            }
            case 701: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_muliple_face));
                break;
            }
            case 2: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_too_far));
                break;
            }
            case 3: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_too_close));
                break;
            }
            case 4: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_not_center));
                break;
            }
            case 5: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_not_stable));
                break;
            }
            case 6: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_too_dark));
                break;
            }
            case 7: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_too_bright));
                break;
            }
            case 8: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_not_center));
                break;
            }
            case 9: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_not_center));
                break;
            }
            case 10: 
            case 15: 
            case 16: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_occlusion));
                break;
            }
            case 24: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_needs_head_up));
                break;
            }
            case 23: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_needs_head_down));
                break;
            }
            case 22: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_needs_head_left));
                break;
            }
            case 21: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_tips_needs_head_right));
                break;
            }
        }
    }

    public void setTipsMessage() {
        int n = this.getCurrentAction();
        switch (n) {
            case 2: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_action_head_left), true, false);
                break;
            }
            case 4: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_action_head_right), false, true);
                break;
            }
            case 16: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_action_open_mouth), false, false);
                break;
            }
            case 8: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_action_blink_eye), false, false);
                break;
            }
            case 256: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_action_head_shake), false, false);
                break;
            }
            case 32: 
            case 64: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_action_head_up_down), false, false);
                break;
            }
            case 1024: {
                this.roundMaskView.setTipsMessage(this.getString(R.string.td_live_action_phone_forward_backward), false, false);
                break;
            }
        }
    }

    @Override
    protected void startTipsVoice(int n) {
        super.startTipsVoice(n);
        if (!this.mConfig.isPlaySound() || this.isInterruptedLive) {
            return;
        }
        switch (n) {
            case 6: {
                if (this.getCurrentAction() == 1 || !this.mConfig.isActionDonePlayVoice()) break;
                VoiceUtil.playVoice(this.getContext(), R.raw.td_good);
                break;
            }
            case 1: {
                VoiceUtil.playVoice(this.getContext(), R.raw.td_main);
                break;
            }
            case 2: {
                VoiceUtil.playVoice(this.getContext(), R.raw.td_left);
                break;
            }
            case 4: {
                VoiceUtil.playVoice(this.getContext(), R.raw.td_right);
                break;
            }
            case 8: {
                VoiceUtil.playVoice(this.getContext(), R.raw.td_eye);
                break;
            }
            case 16: {
                VoiceUtil.playVoice(this.getContext(), R.raw.td_mouth);
                break;
            }
            case 256: {
                VoiceUtil.playVoice(this.getContext(), R.raw.td_shake);
                break;
            }
            case 32: 
            case 64: {
                VoiceUtil.playVoice(this.getContext(), R.raw.td_up_down);
                break;
            }
            case 1024: {
                VoiceUtil.playVoice(this.getContext(), R.raw.td_forward_backward);
            }
        }
    }

    @Override
    protected void stopTipsVoice() {
        super.stopTipsVoice();
        VoiceUtil.stopVoice();
    }

    @Override
    protected void showHackDialog() {
        super.showHackDialog();
        if (this.actionAnimation != null && this.actionAnimation.isRunning()) {
            this.actionAnimation.stop();
        }
        this.roundMaskView.startAnim(2);
        Message message = this.handler.obtainMessage(3001, 0, 0);
        this.handler.sendMessageDelayed(message, 500L);
        this.handler.obtainMessage(3004, 0, 0).sendToTarget();
    }

    @Override
    protected void dismissHackDialog() {
        super.dismissHackDialog();
        this.roundMaskView.stopAnim();
        this.handler.sendEmptyMessage(3005);
        this.handler.removeMessages(3001);
    }

    @Override
    protected void dispatchHandleMessage(Message message) {
        super.dispatchHandleMessage(message);
        switch (message.what) {
            case 3001: {
                this.timeoutTextView.setVisibility(8);
                int n = message.arg1 % 3;
                if (n == 0) {
                    this.tipsTextSwitcher.setCurrentText((CharSequence)this.getString(R.string.td_live_tips_process_1));
                } else if (n == 1) {
                    this.tipsTextSwitcher.setCurrentText((CharSequence)this.getString(R.string.td_live_tips_process_2));
                } else {
                    this.tipsTextSwitcher.setCurrentText((CharSequence)this.getString(R.string.td_live_tips_process_3));
                }
                Message message2 = this.handler.obtainMessage(3001, ++message.arg1, 0);
                this.handler.sendMessageDelayed(message2, 500L);
                break;
            }
            case 3004: {
                if (!this.mConfig.isShowMaskImage()) break;
                this.mIvMask.setVisibility(0);
                break;
            }
            case 3005: {
                this.mIvMask.setVisibility(8);
                break;
            }
            case 3002: {
                this.doFailCallback(message.arg1, message.arg2);
                this.showTipsDialog(message.arg1);
                break;
            }
        }
    }

    private void showTipsDialog(final int n) {
        if (this.liveTimeOutDialog.isShowing()) {
            return;
        }
        switch (n) {
            case 700: {
                this.liveDialogTitle.setText(R.string.td_live_result_fail);
                this.liveDialogContent.setText(R.string.td_live_tips_no_face);
                break;
            }
            case 702: {
                this.liveDialogTitle.setText(R.string.td_live_result_fail);
                this.liveDialogContent.setText(R.string.td_live_tips_change_face);
                break;
            }
            case 704: 
            case 735: 
            case 736: 
            case 737: 
            case 748: 
            case 749: 
            case 750: 
            case 751: 
            case 752: 
            case 753: {
                this.liveDialogTitle.setText(R.string.td_live_result_fail);
                this.liveDialogContent.setText(R.string.td_live_tips_action_not_standard_2);
                break;
            }
            case 707: 
            case 708: {
                this.liveDialogTitle.setText(R.string.td_live_result_fail);
                this.liveDialogContent.setText(R.string.td_live_result_fail);
                break;
            }
            case 703: {
                this.liveDialogTitle.setText(R.string.td_live_tips_dialog_timeout);
                this.liveDialogContent.setText(R.string.td_live_tips_dialog_tips);
                break;
            }
            case 714: {
                this.liveDialogTitle.setText(R.string.td_live_result_fail);
                this.liveDialogContent.setText(R.string.td_live_tips_initerr);
                break;
            }
            case 705: {
                this.liveDialogTitle.setText(R.string.td_live_result_fail);
                this.liveDialogContent.setText(R.string.td_live_tips_action_restart_live);
                break;
            }
            default: {
                this.liveDialogTitle.setText(R.string.td_live_result_fail);
                this.liveDialogContent.setText(R.string.td_live_tips_dialog_tips);
            }
        }
        this.liveTimeOutDialog.setOnDialogClickListener(new OnDialogClickListener(){

            public void onDialogClick(Dialog dialog, int n2) {
                ErrorInfo errorInfo = new ErrorInfo(n);
                if (n2 == R.id.td_live_cancel) {
                    TDLiveFragment.this.finishActivity();
                    if (TDLiveFragment.this.mConfig.getFrontDetectCallback() != null) {
                        TDLiveFragment.this.mConfig.getFrontDetectCallback().onLivenessCancel(743);
                    }
                } else if (n2 == R.id.td_live_restart) {
                    if (n != 714) {
                        dialog.dismiss();
                    }
                    if (TDLiveFragment.this.mConfig.getErrorDialogRetryCallback() != null) {
                        errorInfo.setErrorCode(744);
                        TDLiveFragment.this.mConfig.getErrorDialogRetryCallback().onClickRetry(errorInfo);
                    }
                    TDLiveFragment.this.tryAgain();
                }
            }
        });
        if (this.getActivity() != null && !this.getActivity().isFinishing()) {
            this.liveTimeOutDialog.show(1);
        }
    }

    private void tryAgain() {
        this.handler.removeMessages(3001);
        this.handler.sendEmptyMessage(3005);
        this.actionGroupCount = this.mConfig.getActionGroupCount();
        this.isPlayedAgainVoice = false;
        this.isSetResult = false;
        this.isStartActivity = false;
        this.restartActionDetect();
        this.isInterruptedLive = false;
    }

    @Override
    protected void start2ResultPage(int n) {
        super.start2ResultPage(n);
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity == null) {
            return;
        }
        if (n == 618 && !this.mConfig.isShowSuccessResultPage()) {
            fragmentActivity.finish();
            return;
        }
        if (n != 618 && !this.mConfig.isShowFailResultPage()) {
            fragmentActivity.finish();
            return;
        }
        LiveResultActivity.start2LiveFrontResultActivity((Context)fragmentActivity, n, this.mConfig.isFrontHack(), this.getBestFace());
        fragmentActivity.finish();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (this.localBroadcastManager != null && this.liveAntiBroadcastReceiver != null) {
            this.localBroadcastManager.unregisterReceiver((BroadcastReceiver)this.liveAntiBroadcastReceiver);
        }
    }

    private static String linkxxxxx(String string2, int n) {
        try {
            int n2;
            int n3;
            int n4 = string2.length() / 2;
            char[] cArray = string2.toCharArray();
            byte[] byArray = new byte[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = n3 * 2;
                byArray[n3] = (byte)("0123456789abcdef".indexOf(cArray[n2]) << 4 | "0123456789abcdef".indexOf(cArray[n2 + 1]));
            }
            n3 = (byte)(n ^ 0x33);
            n2 = byArray.length;
            byArray[0] = (byte)(byArray[0] ^ 7);
            byte by = byArray[0];
            for (int i = 1; i < n2; ++i) {
                byte by2 = byArray[i];
                byArray[i] = (byte)(byArray[i] ^ by ^ n3);
                by = by2;
            }
            return new String(byArray, "utf-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String i1i1iI1I11iI(String string2) {
        try {
            byte[] byArray = Base64.decode((String)string2, (int)0);
            int n = byArray.length;
            byte[] byArray2 = "AEzWRelf".getBytes();
            int n2 = byArray2.length;
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)(byArray[i] ^ byArray2[i % n2]);
            }
            return new String(byArray, "utf-8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public class LiveAntiBroadcastReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getStringExtra(TDLiveFragment.linkxxxxx("6635762870296d", 4));
            LoggerUtil.d(TDLiveFragment.i1i1iI1I11iI("FQE2PiQAKhQgIhcyPBFCCS8XHzQ3DBoDYaP08rTx2oPJ9Z/u7YP+y6b+6bHM+YPa22Va") + string2);
            TDLiveFragment.this.mConfig.platformActionSequence(string2);
            TDLiveFragment.this.tryAgain();
        }
    }
}

