/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.liveness.cw.libproject.sm2;

import java.math.BigInteger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.RandomDSAKCalculator;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.util.encoders.Hex;

class SM2Signer
implements Signer,
ECConstants {
    private final DSAKCalculator a;
    private final Digest b;
    private final DSAEncoding c;
    private ECDomainParameters d;
    private ECPoint e;
    private ECKeyParameters f;

    public SM2Signer() {
        SM3Digest sM3Digest;
        SM2Signer sM2Signer = sM2Signer2;
        SM2Signer sM2Signer2 = StandardDSAEncoding.INSTANCE;
        SM3Digest sM3Digest2 = sM3Digest;
        sM3Digest = new SM3Digest();
        sM2Signer((DSAEncoding)sM2Signer2, (Digest)sM3Digest2);
    }

    public SM2Signer(Digest digest) {
        this((DSAEncoding)StandardDSAEncoding.INSTANCE, digest);
    }

    public SM2Signer(DSAEncoding dSAEncoding) {
        SM3Digest sM3Digest;
        RandomDSAKCalculator randomDSAKCalculator;
        SM2Signer sM2Signer = randomDSAKCalculator;
        randomDSAKCalculator = new RandomDSAKCalculator();
        v1.a = sM2Signer;
        v1.c = dSAEncoding;
        sM2Signer = sM3Digest;
        sM3Digest = new SM3Digest();
        v1.b = sM2Signer;
    }

    public SM2Signer(DSAEncoding dSAEncoding, Digest digest) {
        RandomDSAKCalculator randomDSAKCalculator;
        SM2Signer sM2Signer = randomDSAKCalculator;
        randomDSAKCalculator = new RandomDSAKCalculator();
        v1.a = sM2Signer;
        v1.c = dSAEncoding;
        v1.b = digest;
    }

    private boolean a(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = sM2Signer2.d.getN();
        if (bigInteger.compareTo(ONE) >= 0 && bigInteger.compareTo(bigInteger3) < 0) {
            if (bigInteger2.compareTo(ONE) >= 0 && bigInteger2.compareTo(bigInteger3) < 0) {
                BigInteger bigInteger4 = sM2Signer2.a(bigInteger3, sM2Signer2.b());
                BigInteger bigInteger5 = bigInteger.add(bigInteger2).mod(bigInteger3);
                if (bigInteger5.equals(ZERO)) {
                    return false;
                }
                SM2Signer sM2Signer = sM2Signer2;
                SM2Signer sM2Signer2 = ((ECPublicKeyParameters)sM2Signer.f).getQ();
                sM2Signer2 = ECAlgorithms.sumOfTwoMultiplies((ECPoint)sM2Signer.d.getG(), (BigInteger)bigInteger2, (ECPoint)sM2Signer2, (BigInteger)bigInteger5).normalize();
                if (sM2Signer2.isInfinity()) {
                    return false;
                }
                return bigInteger4.add(sM2Signer2.getAffineXCoord().toBigInteger()).mod(bigInteger3).equals(bigInteger);
            }
            return false;
        }
        return false;
    }

    private byte[] b() {
        byte[] byArray = new byte[this.b.getDigestSize()];
        SM2Signer sM2Signer = this;
        sM2Signer.b.doFinal(byArray, 0);
        sM2Signer.reset();
        return byArray;
    }

    private byte[] a(byte[] byArray) {
        SM2Signer sM2Signer = this;
        sM2Signer.b.reset();
        sM2Signer.a(sM2Signer.b, byArray);
        sM2Signer.a(sM2Signer.b, this.d.getCurve().getA());
        sM2Signer.a(sM2Signer.b, this.d.getCurve().getB());
        sM2Signer.a(sM2Signer.b, this.d.getG().getAffineXCoord());
        sM2Signer.a(sM2Signer.b, this.d.getG().getAffineYCoord());
        sM2Signer.a(sM2Signer.b, this.e.getAffineXCoord());
        sM2Signer.a(sM2Signer.b, this.e.getAffineYCoord());
        byte[] byArray2 = new byte[sM2Signer.b.getDigestSize()];
        this.b.doFinal(byArray2, 0);
        return byArray2;
    }

    private void a(Digest digest, byte[] byArray) {
        int n = byArray.length * 8;
        digest.update((byte)(n >> 8 & 0xFF));
        digest.update((byte)(n & 0xFF));
        digest.update(byArray, 0, byArray.length);
    }

    private void a(Digest digest, ECFieldElement eCFieldElement) {
        byte[] byArray = eCFieldElement.getEncoded();
        Object object = byArray;
        int n = byArray.length;
        digest.update((byte[])object, 0, n);
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithID) {
            ParametersWithID parametersWithID = (ParametersWithID)cipherParameters;
            cipherParameters = parametersWithID.getParameters();
            if (parametersWithID.getID().length >= 8192) {
                throw new IllegalArgumentException("SM2 user ID must be less than 2^16 bits long");
            }
        } else {
            Hex.decodeStrict((String)"31323334353637383132333435363738");
        }
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                Object object = (ParametersWithRandom)cipherParameters;
                sM2Signer2.f = (ECKeyParameters)object.getParameters();
                cipherParameters = sM2Signer2.f.getParameters();
                sM2Signer2.d = cipherParameters;
                ParametersWithRandom parametersWithRandom = object;
                object = cipherParameters.getN();
                sM2Signer2.a.init((BigInteger)object, parametersWithRandom.getRandom());
            } else {
                ECDomainParameters eCDomainParameters;
                sM2Signer2.f = (ECKeyParameters)cipherParameters;
                sM2Signer2.d = eCDomainParameters = sM2Signer2.f.getParameters();
                sM2Signer2.a.init(eCDomainParameters.getN(), CryptoServicesRegistrar.getSecureRandom());
            }
            sM2Signer2.e = sM2Signer2.a().multiply(sM2Signer2.d.getG(), ((ECPrivateKeyParameters)sM2Signer2.f).getD()).normalize();
        } else {
            SM2Signer sM2Signer = sM2Signer2;
            SM2Signer sM2Signer2 = (ECKeyParameters)cipherParameters;
            sM2Signer.f = sM2Signer2;
            sM2Signer.d = sM2Signer2.getParameters();
            sM2Signer.e = ((ECPublicKeyParameters)sM2Signer.f).getQ();
        }
    }

    public void update(byte by) {
        this.b.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.b.update(byArray, n, n2);
    }

    public boolean verifySignature(byte[] byArray) {
        BigInteger[] bigIntegerArray;
        SM2Signer sM2Signer;
        try {
            SM2Signer sM2Signer2 = bigInteger;
            sM2Signer = sM2Signer2;
            BigInteger[] bigIntegerArray2 = sM2Signer2.c.decode(((SM2Signer)((Object)bigInteger)).d.getN(), byArray);
            bigIntegerArray = bigIntegerArray2;
            BigInteger bigInteger = bigIntegerArray2[0];
        }
        catch (Exception exception) {
            return false;
        }
        return sM2Signer.a(bigInteger, bigIntegerArray[1]);
    }

    public void reset() {
        this.b.reset();
    }

    public byte[] generateSignature() throws CryptoException {
        BigInteger bigInteger;
        SM2Signer sM2Signer;
        BigInteger bigInteger2;
        SM2Signer sM2Signer2 = this;
        Object object = sM2Signer2.b();
        BigInteger bigInteger3 = sM2Signer2.d.getN();
        object = sM2Signer2.a(bigInteger3, (byte[])object);
        BigInteger bigInteger4 = ((ECPrivateKeyParameters)sM2Signer2.f).getD();
        ECMultiplier eCMultiplier = sM2Signer2.a();
        do {
            sM2Signer = this;
            bigInteger = sM2Signer.a.nextK();
        } while ((bigInteger2 = ((BigInteger)object).add(eCMultiplier.multiply(sM2Signer.d.getG(), bigInteger).normalize().getAffineXCoord().toBigInteger()).mod(bigInteger3)).equals(ZERO) || bigInteger2.add(bigInteger).equals(bigInteger3) || (bigInteger = bigInteger4.add(ONE).modInverse(bigInteger3).multiply(bigInteger.subtract(bigInteger2.multiply(bigInteger4)).mod(bigInteger3)).mod(bigInteger3)).equals(ZERO));
        try {
            return this.c.encode(this.d.getN(), bigInteger2, bigInteger);
        }
        catch (Exception exception) {
            throw new CryptoException("unable to encode signature: " + exception.getMessage(), (Throwable)exception);
        }
    }

    protected ECMultiplier a() {
        return new FixedPointCombMultiplier();
    }

    protected BigInteger a(BigInteger bigInteger, byte[] byArray) {
        return new BigInteger(1, byArray);
    }
}

