/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.timer;

import java.util.HashMap;
import java.util.Map;

public class Timer {
    private static final String DEFAULT_TIMER_KEY = "default";
    private static Map<String, Long> timers = new HashMap<String, Long>();

    public static void start() {
        Timer.start(DEFAULT_TIMER_KEY);
    }

    public static void start(String timerKey) {
        timers.put(timerKey, System.nanoTime());
    }

    public static long getElapsedTime() {
        return Timer.getElapsedTime(DEFAULT_TIMER_KEY);
    }

    public static long getElapsedTime(String timerKey) {
        long now = System.nanoTime();
        if (timers.containsKey(timerKey)) {
            long before = timers.get(timerKey);
            return now - before;
        }
        return 0L;
    }

    public static void reset() {
        Timer.reset(DEFAULT_TIMER_KEY);
    }

    public static void reset(String timerKey) {
        timers.put(timerKey, System.nanoTime());
    }

    public static long stop() {
        return Timer.stop(DEFAULT_TIMER_KEY);
    }

    public static long stop(String timerKey) {
        long elapsedTime = Timer.getElapsedTime(timerKey);
        timers.remove(timerKey);
        return elapsedTime;
    }
}

