/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.json;

import com.truebanana.log.Log;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONUtils {
    private static Object getFromJSONObjectOrArray(Object jsonObjectOrArray, String keyPath) {
        Object vValue = null;
        if (jsonObjectOrArray != null) {
            String[] vKeys = keyPath.split("/");
            Object vTempObject = jsonObjectOrArray;
            String vTempValue = "";
            for (int i = 0; i < vKeys.length; ++i) {
                try {
                    if (vTempObject instanceof JSONObject) {
                        if (i == vKeys.length - 1) {
                            vValue = ((JSONObject)vTempObject).get(vKeys[i]);
                        } else {
                            vTempValue = ((JSONObject)vTempObject).getString(vKeys[i]);
                        }
                    } else {
                        if (!(vTempObject instanceof JSONArray)) break;
                        if (i == vKeys.length - 1) {
                            vValue = ((JSONArray)vTempObject).get(Integer.valueOf(vKeys[i]).intValue());
                        } else {
                            vTempValue = ((JSONArray)vTempObject).getString(Integer.valueOf(vKeys[i]).intValue());
                        }
                    }
                    if (vTempValue == null) break;
                    if (vTempValue.length() <= 0) continue;
                    try {
                        vTempObject = new JSONObject(vTempValue);
                        continue;
                    }
                    catch (Exception e) {
                        try {
                            vTempObject = new JSONArray(vTempValue);
                            continue;
                        }
                        catch (Exception e1) {
                            Log.e("JSONUtils.getFromJSONObjectOrArray()", e.getMessage());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    Log.e("JSONUtils.getFromJSONObjectOrArray()", e.getMessage());
                }
            }
        }
        return vValue;
    }

    public static JSONObject toJSONObject(String jsonString) {
        JSONObject vJSON = null;
        try {
            if (jsonString != null && jsonString.length() > 0) {
                vJSON = new JSONObject(jsonString);
            }
        }
        catch (Exception e) {
            Log.e("JSONUtils.toJSONObject()", e.getMessage());
        }
        return vJSON;
    }

    public static JSONArray toJSONArray(String jsonString) {
        JSONArray vJSON = null;
        try {
            if (jsonString != null && jsonString.length() > 0) {
                vJSON = new JSONArray(jsonString);
            }
        }
        catch (Exception e) {
            Log.e("JSONUtils.toJSONArray()", e.getMessage());
        }
        return vJSON;
    }

    public static JSONObject getJSONObject(JSONObject jsonObject, String keyPath) {
        return JSONUtils.toJSONObject(JSONUtils.getString(jsonObject, keyPath));
    }

    public static JSONArray getJSONArray(JSONObject jsonObject, String keyPath) {
        return JSONUtils.toJSONArray(JSONUtils.getString(jsonObject, keyPath));
    }

    public static String getString(JSONObject jsonObject, String keyPath) {
        String value = String.valueOf(JSONUtils.getFromJSONObjectOrArray(jsonObject, keyPath));
        return value.equals("null") ? null : value;
    }

    public static int getInt(JSONObject jsonObject, String keyPath) throws NumberFormatException {
        return Integer.parseInt(JSONUtils.getString(jsonObject, keyPath));
    }

    public static long getLong(JSONObject jsonObject, String keyPath) throws NumberFormatException {
        return Long.parseLong(JSONUtils.getString(jsonObject, keyPath));
    }

    public static float getFloat(JSONObject jsonObject, String keyPath) throws NumberFormatException {
        return Float.parseFloat(JSONUtils.getString(jsonObject, keyPath));
    }

    public static double getDouble(JSONObject jsonObject, String keyPath) throws NumberFormatException {
        return Double.parseDouble(JSONUtils.getString(jsonObject, keyPath));
    }

    public static JSONObject getJSONObject(JSONArray jsonArray, String keyPath) {
        return JSONUtils.toJSONObject(JSONUtils.getString(jsonArray, keyPath));
    }

    public static JSONArray getJSONArray(JSONArray jsonArray, String keyPath) {
        return JSONUtils.toJSONArray(JSONUtils.getString(jsonArray, keyPath));
    }

    public static String getString(JSONArray jsonArray, String keyPath) {
        String value = String.valueOf(JSONUtils.getFromJSONObjectOrArray(jsonArray, keyPath));
        return value.equals("null") ? null : value;
    }

    public static int getInt(JSONArray jsonArray, String keyPath) throws NumberFormatException {
        return Integer.parseInt(JSONUtils.getString(jsonArray, keyPath));
    }

    public static long getLong(JSONArray jsonArray, String keyPath) throws NumberFormatException {
        return Long.parseLong(JSONUtils.getString(jsonArray, keyPath));
    }

    public static float getFloat(JSONArray jsonArray, String keyPath) throws NumberFormatException {
        return Float.parseFloat(JSONUtils.getString(jsonArray, keyPath));
    }

    public static double getDouble(JSONArray jsonArray, String keyPath) throws NumberFormatException {
        return Double.parseDouble(JSONUtils.getString(jsonArray, keyPath));
    }
}

