/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.widget.ImageView;
import com.truebanana.async.Async;
import com.truebanana.async.BackgroundTask;
import com.truebanana.bitmap.BitmapDiskCache;
import com.truebanana.bitmap.BitmapMemCache;
import com.truebanana.http.BitmapResponseListener;
import com.truebanana.http.HTTPRequest;
import com.truebanana.log.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BitmapLoader {
    private static BitmapMemCache memCache;
    private static BitmapDiskCache diskCache;
    private static RequestOptions defaultRequestOptions;

    private static void initializeCacheAsNeeded() {
        if (memCache == null) {
            memCache = new BitmapMemCache();
        }
    }

    public static void enableDiskCache(Context context) {
        diskCache = new BitmapDiskCache(new File(context.getCacheDir(), "images"));
        Log.d("BitmapLoader", "Disk cache enabled");
    }

    public static void setDefaultRequestOptions(RequestOptions options) {
        defaultRequestOptions = options;
    }

    public static void displayBitmap(String url, ImageView imageView) {
        BitmapLoader.displayBitmap(url, imageView, defaultRequestOptions);
    }

    public static void displayBitmap(String url, ImageView imageView, RequestOptions options) {
        BitmapLoader.displayBitmap(url, 0, 0, imageView, options);
    }

    public static void displayBitmap(String url, int width, int height, ImageView imageView) {
        BitmapLoader.displayBitmap(url, width, height, imageView, defaultRequestOptions);
    }

    public static void displayBitmap(final String url, int width, int height, final ImageView imageView, RequestOptions options) {
        BitmapLoader.initializeCacheAsNeeded();
        if (memCache.contains(url)) {
            Log.d("BitmapLoader", "Image in mem cache, loading from memory...");
            imageView.setImageBitmap((Bitmap)memCache.get(url));
        } else if (diskCache != null && diskCache.contains(url)) {
            Log.d("BitmapLoader", "Image in disk cache, loading from disk...");
            Async.executeAsync(new BackgroundTask<Bitmap>(){

                @Override
                public Bitmap doInBackground() {
                    return diskCache.get(url);
                }

                @Override
                public void onPostExecute(Bitmap result) {
                    imageView.setImageBitmap(result);
                    memCache.put(url, result);
                }
            }, true);
        } else {
            Log.d("BitmapLoader", "Image not cached, retrieving...");
            HTTPRequest.create(url).addHeaders(options.headers).setConnectTimeout(options.connectTimeout).setReadTimeout(options.readTimeout).setSSLVerificationEnabled(options.sslVerification).setLogTag("BitmapLoader").setHTTPResponseListener(new BitmapResponseListener(width, height){

                @Override
                public void onDecodingSuccessful(Bitmap bitmap) {
                    imageView.setImageBitmap(bitmap);
                    memCache.put(url, bitmap);
                    if (diskCache != null) {
                        diskCache.put(url, bitmap);
                    }
                }

                @Override
                public void onDecodingFailed() {
                }
            }).executeAsync();
        }
    }

    static {
        defaultRequestOptions = new RequestOptions();
    }

    public static class RequestOptions {
        Map<String, String> headers = new HashMap<String, String>();
        boolean sslVerification = false;
        private int readTimeout = 10000;
        private int connectTimeout = 10000;

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public RequestOptions setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public RequestOptions addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public RequestOptions addHeaders(Map<String, String> headers) {
            Set<Map.Entry<String, String>> entries = headers.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                this.addHeader(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public boolean isSSLVerificationEnabled() {
            return this.sslVerification;
        }

        public RequestOptions setSSLVerificationEnabled(boolean enabled) {
            this.sslVerification = enabled;
            return this;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public RequestOptions setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public RequestOptions setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }
    }
}

