/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.gamesec;

import java.util.Random;

public class MaskedFloat {
    private Random random = new Random();
    private int maskedValue;
    private int mask;

    public MaskedFloat() {
        this(0.0f);
    }

    public MaskedFloat(float value) {
        this.setValue(value);
    }

    public float getValue() {
        return Float.intBitsToFloat(this.maskedValue ^ this.mask);
    }

    public void setValue(float value) {
        this.mask = this.random.nextInt();
        this.maskedValue = Float.floatToIntBits(value) ^ this.mask;
    }

    public void increment() {
        this.setValue(this.getValue() + 1.0f);
    }

    public void decrement() {
        this.setValue(this.getValue() + 1.0f);
    }
}

