/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle;

import com.trello.rxlifecycle.LifecycleTransformer;
import com.trello.rxlifecycle.UntilCorrespondingEventObservableTransformer;
import com.trello.rxlifecycle.UntilEventObservableTransformer;
import com.trello.rxlifecycle.UntilLifecycleObservableTransformer;
import com.trello.rxlifecycle.internal.Preconditions;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import rx.Observable;
import rx.functions.Func1;

public class RxLifecycle {
    private RxLifecycle() {
        throw new AssertionError((Object)"No instances");
    }

    @Nonnull
    @CheckReturnValue
    public static <T, R> LifecycleTransformer<T> bindUntilEvent(@Nonnull Observable<R> lifecycle, @Nonnull R event) {
        Preconditions.checkNotNull(lifecycle, "lifecycle == null");
        Preconditions.checkNotNull(event, "event == null");
        return new UntilEventObservableTransformer(lifecycle, event);
    }

    @Nonnull
    @CheckReturnValue
    public static <T, R> LifecycleTransformer<T> bind(@Nonnull Observable<R> lifecycle) {
        Preconditions.checkNotNull(lifecycle, "lifecycle == null");
        return new UntilLifecycleObservableTransformer(lifecycle);
    }

    @Nonnull
    @CheckReturnValue
    public static <T, R> LifecycleTransformer<T> bind(@Nonnull Observable<R> lifecycle, @Nonnull Func1<R, R> correspondingEvents) {
        Preconditions.checkNotNull(lifecycle, "lifecycle == null");
        Preconditions.checkNotNull(correspondingEvents, "correspondingEvents == null");
        return new UntilCorrespondingEventObservableTransformer(lifecycle.share(), correspondingEvents);
    }
}

