/*
 * Decompiled with CFR 0.152.
 */
package com.tp.common;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.os.Looper;
import android.os.StatFs;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.tp.adx.sdk.util.CreativeOrientation;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.Preconditions;
import com.tp.adx.sdk.util.Reflection;
import com.tp.adx.sdk.util.Utils;
import com.tp.adx.sdk.util.VersionCode;
import com.tradplus.ads.base.util.PrivacyDataInfo;
import java.io.File;

public class DeviceUtils {
    public static boolean isNetworkAvailable(Context context) {
        block6: {
            block5: {
                if (context == null) {
                    return false;
                }
                try {
                    context = (ConnectivityManager)context.getSystemService("connectivity");
                    if (context != null) break block5;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            context = context.getActiveNetworkInfo();
            if (context == null) break block6;
            return context.isConnected();
        }
        return false;
    }

    public static void isMainThread() {
        boolean bl = Looper.myLooper() == Looper.getMainLooper();
        InnerLog.i("TradPlus isMainThread", "isMainThread == " + bl);
    }

    public static int getCPUProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static int memoryCacheSizeBytes(Context context) {
        long l2;
        block5: {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            l2 = activityManager.getMemoryClass();
            if (VersionCode.currentApiLevel().isAtLeast(VersionCode.HONEYCOMB)) {
                Context context2 = context;
                int n2 = ApplicationInfo.class.getDeclaredField("FLAG_LARGE_HEAP").getInt(null);
                if (!Utils.bitMaskContainsFlag(context2.getApplicationInfo().flags, n2)) break block5;
                try {
                    long l3;
                    l2 = l3 = (long)((Integer)new Reflection.MethodBuilder(activityManager, "getLargeMemoryClass").execute()).intValue();
                }
                catch (Exception exception) {
                    InnerLog.d("Unable to reflectively determine large heap size on Honeycomb and above.");
                }
            }
        }
        long l4 = l2 / 8L * 1024L * 1024L;
        return (int)Math.min(0x1E00000L, l4);
    }

    public static long diskCacheSizeBytes(File file, long l2) {
        StatFs statFs;
        StatFs statFs2 = statFs;
        long l3 = new StatFs(file.getAbsolutePath()).getBlockCount();
        long l4 = l3 * (long)statFs2.getBlockSize();
        try {
            l2 = l4 / 50L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InnerLog.v("Unable to calculate 2% of available disk space, defaulting to minimum");
        }
        return Math.max(Math.min(l2, 0x6400000L), 0x1E00000L);
    }

    public static long diskCacheSizeBytes(File file) {
        return DeviceUtils.diskCacheSizeBytes(file, 0x1E00000L);
    }

    public static int getScreenOrientation(Activity activity) {
        Activity activity2 = activity;
        int n2 = activity2.getWindowManager().getDefaultDisplay().getRotation();
        int n3 = activity2.getResources().getConfiguration().orientation;
        if (1 == n3) {
            n2 = n2 != 1 && n2 != 2 ? 1 : 9;
        } else if (2 == n3) {
            n2 = n2 != 2 && n2 != 3 ? 0 : 8;
        } else {
            InnerLog.v("Unknown screen orientation. Defaulting to portrait.");
            n2 = 9;
        }
        return n2;
    }

    public static boolean isScreenLandscapeOrientation(Context context) {
        if (context == null) {
            return false;
        }
        if ((context = context.getResources()) == null) {
            return false;
        }
        if ((context = context.getConfiguration()) == null) {
            return false;
        }
        return context.orientation == 2;
    }

    public static String getScreenOrientationToString(Context context) {
        return DeviceUtils.isScreenLandscapeOrientation(context) ? "\u6a2a\u5c4f" : "\u7ad6\u5c4f";
    }

    public static String getScreenOrientationToString(int n2) {
        if (n2 != 3 && n2 != 0) {
            if (n2 == 1) {
                return "\u7ad6\u5c4f";
            }
            if (n2 == 2) {
                return "\u6a2a\u5c4f";
            }
            if (n2 == 4) {
                return "\u4ec5\u7ad6\u5c4f";
            }
            if (n2 == 5) {
                return "\u4ec5\u6a2a\u5c4f";
            }
            return "\u81ea\u9002\u5e94";
        }
        return "\u81ea\u9002\u5e94";
    }

    public static void lockOrientation(Activity activity, CreativeOrientation creativeOrientation) {
        if (Preconditions.NoThrow.checkNotNull((Object)creativeOrientation) && Preconditions.NoThrow.checkNotNull(activity)) {
            Activity activity2 = activity;
            int n2 = ((WindowManager)activity2.getSystemService("window")).getDefaultDisplay().getRotation();
            int n3 = activity2.getResources().getConfiguration().orientation;
            if (1 == n3) {
                n2 = n2 != 1 && n2 != 2 ? 1 : 9;
            } else if (2 == n3) {
                n2 = n2 != 2 && n2 != 3 ? 0 : 8;
            } else {
                InnerLog.v("Unknown screen orientation. Defaulting to portrait.");
                n2 = 9;
            }
            int n4 = CreativeOrientation.PORTRAIT == creativeOrientation ? (9 == n2 ? 9 : 1) : (CreativeOrientation.LANDSCAPE == creativeOrientation ? (8 == n2 ? 8 : 0) : 4);
            activity.setRequestedOrientation(n4);
            return;
        }
    }

    public static Point getDeviceDimensions(Context context) {
        Integer n2 = null;
        Integer n3 = null;
        if (PrivacyDataInfo.getInstance().getOSVersion() >= 13) {
            Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            if (PrivacyDataInfo.getInstance().getOSVersion() >= 17) {
                Point point;
                n2 = point;
                display.getRealSize(new Point());
                Integer n4 = n2;
                n2 = ((Point)n4).x;
                n3 = ((Point)n4).y;
            } else {
                n2 = (Integer)new Reflection.MethodBuilder(display, "getRawWidth").execute();
                try {
                    n3 = (Integer)new Reflection.MethodBuilder(display, "getRawHeight").execute();
                }
                catch (Exception exception) {
                    InnerLog.d("Display#getRawWidth/Height failed." + exception);
                }
            }
        }
        if (n2 == null || n3 == null) {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            n2 = displayMetrics.widthPixels;
            n3 = displayMetrics.heightPixels;
        }
        int n5 = n2;
        return new Point(n5, n3.intValue());
    }

    @Deprecated
    public static String getIpAddress(IP iP) {
        return null;
    }

    @Deprecated
    public static String getHashedUdid(Context context) {
        return null;
    }

    public static int dip2px(Context context, float f2) {
        return (int)(f2 * context.getResources().getDisplayMetrics().density + 0.5f);
    }

    public static int px2dip(Context context, float f2) {
        float f3;
        float f4 = context.getResources().getDisplayMetrics().density;
        if (f3 <= 0.0f) {
            f4 = 1.0f;
        }
        return (int)(f2 / f4 + 0.5f);
    }

    public static float getScreenWidthDp(Context context) {
        float f2;
        float f3 = context.getResources().getDisplayMetrics().density;
        float f4 = context.getResources().getDisplayMetrics().widthPixels;
        if (f2 <= 0.0f) {
            f3 = 1.0f;
        }
        return f4 / f3 + 0.5f;
    }

    public static String getScreenOrientation(Context context) {
        if (DeviceUtils.isScreenLandscapeOrientation(context)) {
            return "2";
        }
        return "1";
    }

    public static int getScreenHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    @Deprecated
    public static final class IP
    extends Enum<IP> {
        public static final /* enum */ IP IPv4;
        public static final /* enum */ IP IPv6;
        public static final /* synthetic */ IP[] a;

        public static IP[] values() {
            return (IP[])a.clone();
        }

        public static IP valueOf(String string) {
            return Enum.valueOf(IP.class, string);
        }

        static {
            IP iP;
            IP iP2;
            IP iP3 = iP2;
            IPv4 = new IP();
            IP iP4 = iP;
            IPv6 = new IP();
            a = new IP[]{iP3, iP4};
        }
    }

    public static final class ForceOrientation
    extends Enum<ForceOrientation> {
        public static final /* enum */ ForceOrientation FORCE_PORTRAIT;
        public static final /* enum */ ForceOrientation FORCE_LANDSCAPE;
        public static final /* enum */ ForceOrientation DEVICE_ORIENTATION;
        public static final /* enum */ ForceOrientation UNDEFINED;
        public static final /* synthetic */ ForceOrientation[] b;
        public final String a;

        public static ForceOrientation[] values() {
            return (ForceOrientation[])b.clone();
        }

        public static ForceOrientation valueOf(String string) {
            return Enum.valueOf(ForceOrientation.class, string);
        }

        public ForceOrientation(String string2) {
            this.a = string2;
        }

        public static ForceOrientation getForceOrientation(String string) {
            for (ForceOrientation forceOrientation : ForceOrientation.values()) {
                if (!forceOrientation.a.equalsIgnoreCase(string)) continue;
                return forceOrientation;
            }
            return UNDEFINED;
        }

        static {
            ForceOrientation forceOrientation;
            ForceOrientation forceOrientation2;
            ForceOrientation forceOrientation3;
            ForceOrientation forceOrientation4;
            ForceOrientation forceOrientation5 = forceOrientation4;
            FORCE_PORTRAIT = new ForceOrientation("portrait");
            ForceOrientation forceOrientation6 = forceOrientation3;
            FORCE_LANDSCAPE = new ForceOrientation("landscape");
            ForceOrientation forceOrientation7 = forceOrientation2;
            DEVICE_ORIENTATION = new ForceOrientation("device");
            ForceOrientation forceOrientation8 = forceOrientation;
            UNDEFINED = new ForceOrientation("");
            b = new ForceOrientation[]{forceOrientation5, forceOrientation6, forceOrientation7, forceOrientation8};
        }
    }
}

