/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.jayway.jsonpath.internal.path;

import java.util.List;
import shaded.com.jayway.jsonpath.internal.Path;
import shaded.com.jayway.jsonpath.internal.PathRef;
import shaded.com.jayway.jsonpath.internal.function.Parameter;
import shaded.com.jayway.jsonpath.internal.function.PathFunction;
import shaded.com.jayway.jsonpath.internal.function.PathFunctionFactory;
import shaded.com.jayway.jsonpath.internal.function.latebinding.JsonLateBindingValue;
import shaded.com.jayway.jsonpath.internal.function.latebinding.PathLateBindingValue;
import shaded.com.jayway.jsonpath.internal.path.CompiledPath;
import shaded.com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import shaded.com.jayway.jsonpath.internal.path.PathToken;
import shaded.com.jayway.jsonpath.internal.path.RootPathToken;
import shaded.com.jayway.jsonpath.internal.path.WildcardPathToken;

public class FunctionPathToken
extends PathToken {
    private final String functionName;
    private final String pathFragment;
    private List<Parameter> functionParams;

    public FunctionPathToken(String pathFragment, List<Parameter> parameters) {
        this.pathFragment = pathFragment + (parameters != null && parameters.size() > 0 ? "(...)" : "()");
        if (null != pathFragment) {
            this.functionName = pathFragment;
            this.functionParams = parameters;
        } else {
            this.functionName = null;
            this.functionParams = null;
        }
    }

    @Override
    public void evaluate(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        PathFunction pathFunction = PathFunctionFactory.newFunction(this.functionName);
        this.evaluateParameters(currentPath, parent, model, ctx);
        Object result = pathFunction.invoke(currentPath, parent, model, ctx, this.functionParams);
        ctx.addResult(currentPath + "." + this.functionName, parent, result);
        this.cleanWildcardPathToken();
        if (!this.isLeaf()) {
            this.next().evaluate(currentPath, parent, result, ctx);
        }
    }

    private void cleanWildcardPathToken() {
        Path path;
        if (null != this.functionParams && this.functionParams.size() > 0 && null != (path = this.functionParams.get(0).getPath()) && !path.isFunctionPath() && path instanceof CompiledPath) {
            RootPathToken root = ((CompiledPath)path).getRoot();
            for (PathToken tail = root.getNext(); null != tail && null != tail.getNext(); tail = tail.getNext()) {
                if (!(tail.getNext() instanceof WildcardPathToken)) continue;
                tail.setNext(tail.getNext().getNext());
                break;
            }
        }
    }

    private void evaluateParameters(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        if (null != this.functionParams) {
            for (Parameter param : this.functionParams) {
                switch (param.getType()) {
                    case PATH: {
                        PathLateBindingValue pathLateBindingValue = new PathLateBindingValue(param.getPath(), ctx.rootDocument(), ctx.configuration());
                        if (param.hasEvaluated() && pathLateBindingValue.equals(param.getILateBingValue())) break;
                        param.setLateBinding(pathLateBindingValue);
                        param.setEvaluated(true);
                        break;
                    }
                    case JSON: {
                        if (param.hasEvaluated()) break;
                        param.setLateBinding(new JsonLateBindingValue(ctx.configuration().jsonProvider(), param));
                        param.setEvaluated(true);
                    }
                }
            }
        }
    }

    @Override
    public boolean isTokenDefinite() {
        return true;
    }

    @Override
    public String getPathFragment() {
        return "." + this.pathFragment;
    }

    public void setParameters(List<Parameter> parameters) {
        this.functionParams = parameters;
    }

    public List<Parameter> getParameters() {
        return this.functionParams;
    }

    public String getFunctionName() {
        return this.functionName;
    }
}

