/*
 * Decompiled with CFR 0.152.
 */
package com.toomuchcoding.jsonassert;

import com.toomuchcoding.jsonassert.FieldAssertion;
import com.toomuchcoding.jsonassert.JsonAsserterConfiguration;
import com.toomuchcoding.jsonassert.JsonVerifiable;
import com.toomuchcoding.jsonassert.ReadyToCheckAsserter;
import java.util.LinkedList;
import shaded.com.jayway.jsonpath.DocumentContext;

class ArrayValueAssertion
extends FieldAssertion {
    protected ArrayValueAssertion(DocumentContext parsedJson, LinkedList<String> jsonPathBuffer, Object arrayName, JsonAsserterConfiguration jsonAsserterConfiguration) {
        super(parsedJson, jsonPathBuffer, arrayName, jsonAsserterConfiguration);
    }

    protected ArrayValueAssertion(DocumentContext parsedJson, LinkedList<String> jsonPathBuffer, JsonAsserterConfiguration jsonAsserterConfiguration) {
        super(parsedJson, jsonPathBuffer, null, jsonAsserterConfiguration);
    }

    @Override
    public JsonVerifiable contains(Object value) {
        return new ArrayValueAssertion(this.parsedJson, this.jsonPathBuffer, value, this.jsonAsserterConfiguration).isEqualTo(value);
    }

    @Override
    public JsonVerifiable isEqualTo(String value) {
        ReadyToCheckAsserter readyToCheck = new ReadyToCheckAsserter(this.parsedJson, this.jsonPathBuffer, this.fieldName, this.jsonAsserterConfiguration);
        readyToCheck.jsonPathBuffer.offer("[?(@ == " + this.wrapValueWithSingleQuotes(value) + ")]");
        readyToCheck.checkBufferedJsonPathString();
        return readyToCheck;
    }

    @Override
    public JsonVerifiable isEqualTo(Number value) {
        ReadyToCheckAsserter readyToCheck = new ReadyToCheckAsserter(this.parsedJson, this.jsonPathBuffer, this.fieldName, this.jsonAsserterConfiguration);
        readyToCheck.jsonPathBuffer.offer("[?(@ == " + this.numberValue(value) + ")]");
        readyToCheck.checkBufferedJsonPathString();
        return readyToCheck;
    }

    @Override
    public JsonVerifiable matches(String value) {
        ReadyToCheckAsserter readyToCheck = new ReadyToCheckAsserter(this.parsedJson, this.jsonPathBuffer, this.fieldName, this.jsonAsserterConfiguration);
        readyToCheck.jsonPathBuffer.offer("[?(@ =~ /" + ArrayValueAssertion.stringWithEscapedSingleQuotesForRegex(value) + "/)]");
        readyToCheck.checkBufferedJsonPathString();
        return readyToCheck;
    }

    @Override
    public JsonVerifiable isEqualTo(Boolean value) {
        ReadyToCheckAsserter readyToCheck = new ReadyToCheckAsserter(this.parsedJson, this.jsonPathBuffer, this.fieldName, this.jsonAsserterConfiguration);
        readyToCheck.jsonPathBuffer.offer("[?(@ == " + String.valueOf(value) + ")]");
        readyToCheck.checkBufferedJsonPathString();
        return readyToCheck;
    }

    @Override
    public boolean isAssertingAValueInArray() {
        return true;
    }
}

