/*
 * Decompiled with CFR 0.152.
 */
package com.tomer.fadingtextview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.support.annotation.ArrayRes;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.tomer.fadingtextview.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class FadingTextView
extends AppCompatTextView {
    public static final int DEFAULT_TIME_OUT = 15000;
    public static final int MILLISECONDS = 1;
    public static final int SECONDS = 2;
    public static final int MINUTES = 3;
    private Animation fadeInAnimation;
    private Animation fadeOutAnimation;
    private Handler handler;
    private CharSequence[] texts;
    private boolean isShown;
    private int position;
    private int timeout = 15000;
    private boolean stopped;

    public FadingTextView(Context context) {
        super(context);
        this.init();
    }

    public FadingTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
        this.handleAttrs(attrs);
    }

    public FadingTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
        this.handleAttrs(attrs);
    }

    @RequiresApi(api=21)
    public FadingTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init();
        this.handleAttrs(attrs);
    }

    public void resume() {
        this.isShown = true;
        this.startAnimation();
    }

    public void pause() {
        this.isShown = false;
        this.stopAnimation();
    }

    public void stop() {
        this.isShown = false;
        this.stopped = true;
        this.stopAnimation();
    }

    public void restart() {
        this.isShown = true;
        this.stopped = false;
        this.startAnimation();
        this.invalidate();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.pause();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.resume();
    }

    private void init() {
        this.fadeInAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.fadein);
        this.fadeOutAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.fadeout);
        this.handler = new Handler();
        this.isShown = true;
    }

    private void handleAttrs(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.fading_text_view);
        this.texts = a.getTextArray(R.styleable.fading_text_view_texts);
        this.timeout = Math.abs(a.getInteger(R.styleable.fading_text_view_timeout, 14500)) + this.getResources().getInteger(17694722);
        a.recycle();
    }

    public CharSequence[] getTexts() {
        return this.texts;
    }

    public void setTexts(@NonNull String[] texts) {
        if (texts.length < 1) {
            throw new IllegalArgumentException("There must be at least one text");
        }
        this.texts = texts;
        this.stopAnimation();
        this.position = 0;
        this.startAnimation();
    }

    public void setTexts(@ArrayRes int texts) {
        if (this.getResources().getStringArray(texts).length < 1) {
            throw new IllegalArgumentException("There must be at least one text");
        }
        this.texts = this.getResources().getStringArray(texts);
        this.stopAnimation();
        this.position = 0;
        this.startAnimation();
    }

    public void forceRefresh() {
        this.stopAnimation();
        this.startAnimation();
    }

    @Deprecated
    public void setTimeout(int timeout) {
        if (timeout < 1) {
            throw new IllegalArgumentException("Timeout must be longer than 0");
        }
        this.timeout = timeout;
    }

    @Deprecated
    public void setTimeout(double timeout, int timeUnit) {
        int multiplier;
        if (timeout <= 0.0) {
            throw new IllegalArgumentException("Timeout must be longer than 0");
        }
        switch (timeUnit) {
            case 1: {
                multiplier = 1;
                break;
            }
            case 2: {
                multiplier = 1000;
                break;
            }
            case 3: {
                multiplier = 60000;
                break;
            }
            default: {
                multiplier = 1;
            }
        }
        this.timeout = (int)(timeout * (double)multiplier);
    }

    @SuppressLint(value={"reference not found"})
    public void setTimeout(long timeout, java.util.concurrent.TimeUnit timeUnit) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be longer than 0");
        }
        this.timeout = (int)java.util.concurrent.TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    public void startAnimation(Animation animation) {
        if (this.isShown && !this.stopped) {
            super.startAnimation(animation);
        }
    }

    protected void startAnimation() {
        this.setText(this.texts[this.position]);
        this.startAnimation(this.fadeInAnimation);
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                FadingTextView.this.startAnimation(FadingTextView.this.fadeOutAnimation);
                if (FadingTextView.this.getAnimation() != null) {
                    FadingTextView.this.getAnimation().setAnimationListener(new Animation.AnimationListener(){

                        public void onAnimationStart(Animation animation) {
                        }

                        public void onAnimationEnd(Animation animation) {
                            if (FadingTextView.this.isShown) {
                                FadingTextView.this.position = FadingTextView.this.position == FadingTextView.this.texts.length - 1 ? 0 : FadingTextView.this.position + 1;
                                FadingTextView.this.startAnimation();
                            }
                        }

                        public void onAnimationRepeat(Animation animation) {
                        }
                    });
                }
            }
        }, (long)this.timeout);
    }

    private void stopAnimation() {
        this.handler.removeCallbacksAndMessages(null);
        if (this.getAnimation() != null) {
            this.getAnimation().cancel();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimeUnit {
    }
}

