/*
 * Decompiled with CFR 0.152.
 */
package com.tobiasdiez.easybind;

import com.tobiasdiez.easybind.EasyBinding;
import com.tobiasdiez.easybind.Subscription;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;

abstract class FlatMapBindingBase<T, U, O extends ObservableValue<U>>
extends ObjectBinding<U>
implements EasyBinding<U> {
    private final ObservableValue<T> source;
    private final Function<? super T, O> mapper;
    private final InvalidationListener sourceListener = obs -> this.sourceInvalidated();
    private final InvalidationListener weakSourceListener = new WeakInvalidationListener(this.sourceListener);
    private final InvalidationListener mappedListener = obs -> this.mappedInvalidated();
    private final InvalidationListener weakMappedListener = new WeakInvalidationListener(this.mappedListener);
    private O mapped = null;
    private Subscription mappedSubscription = null;

    public FlatMapBindingBase(ObservableValue<T> source, Function<? super T, O> mapper) {
        this.source = source;
        this.mapper = mapper;
        source.addListener(this.weakSourceListener);
    }

    public final void dispose() {
        this.source.removeListener(this.weakSourceListener);
        this.disposeMapped();
    }

    protected final U computeValue() {
        this.setupTargetObservable();
        return (U)(this.mapped != null ? this.mapped.getValue() : null);
    }

    private void setupTargetObservable() {
        if (this.mapped == null) {
            Object baseVal = this.source.getValue();
            this.mapped = (ObservableValue)this.mapper.apply(baseVal);
            this.mappedSubscription = this.observeTargetObservable(this.mapped);
        }
    }

    protected O getTargetObservable() {
        this.setupTargetObservable();
        return this.mapped;
    }

    protected Subscription observeTargetObservable(O target) {
        target.addListener(this.weakMappedListener);
        return () -> target.removeListener(this.weakMappedListener);
    }

    private void disposeMapped() {
        if (this.mapped != null) {
            this.mappedSubscription.unsubscribe();
            this.mappedSubscription = null;
            this.mapped = null;
        }
    }

    private void mappedInvalidated() {
        this.invalidate();
    }

    protected void sourceInvalidated() {
        this.disposeMapped();
        this.invalidate();
    }
}

